/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.inventory;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.ISubMenuHost;
import appeng.hooks.ticking.TickHandler;
import appeng.menu.ISubMenu;
import appeng.menu.guisync.GuiSync;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeysRegistry;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;

public class QuantumArmorMenuHost
extends ItemMenuHost
implements InternalInventoryHost,
ISubMenuHost {
    private static final int MAX_PROCESSING_TIME = 10;
    private final AppEngInternalInventory input = new AppEngInternalInventory((InternalInventoryHost)this, 1, 1);
    private ProgressChangedHandler progressChangedHandler;
    private InventoryChangedHandler invChangeHandler;
    private ClientUpdater clientUpdater;
    private final BiConsumer<Player, ISubMenu> returnToMainMenu;
    private long consumeCardStartTick = -1L;
    @GuiSync(value=10)
    private int selectedItemSlot = -1;

    public QuantumArmorMenuHost(Player player, int inventorySlot, ItemStack stack, BiConsumer<Player, ISubMenu> returnToMainMenu) {
        super(player, Integer.valueOf(inventorySlot), stack);
        this.returnToMainMenu = returnToMainMenu;
        CompoundTag itemTag = this.getItemStack().m_41737_("generic_nbt");
        if (itemTag != null) {
            this.input.readFromNBT(itemTag, "input");
        }
    }

    public void tick() {
        int progressTime;
        ItemStack inputCard = this.input.getStackInSlot(0);
        if (inputCard.m_41619_() || this.selectedItemSlot == -1) {
            this.resetProgress();
            return;
        }
        ItemStack stack = super.getPlayer().m_150109_().m_8020_(this.selectedItemSlot);
        Item item = stack.m_41720_();
        if (!(item instanceof QuantumArmorBase)) {
            this.resetProgress();
            return;
        }
        QuantumArmorBase item2 = (QuantumArmorBase)item;
        QuantumUpgradeBaseItem card = (QuantumUpgradeBaseItem)inputCard.m_41720_();
        if (!item2.isUpgradeAllowed(card.getType()) || item2.hasUpgrade(stack, card.getType())) {
            this.resetProgress();
            return;
        }
        long currentTick = TickHandler.instance().getCurrentTick();
        if (this.consumeCardStartTick == -1L) {
            this.consumeCardStartTick = currentTick;
        }
        if ((progressTime = (int)(currentTick - this.consumeCardStartTick)) >= 10) {
            progressTime = -1;
            this.updateProgress(progressTime);
            UpgradeType type = card.getType();
            if (item2.applyUpgrade(stack, type)) {
                this.input.setItemDirect(0, ItemStack.f_41583_);
                if (this.clientUpdater != null) {
                    this.clientUpdater.updateClient();
                }
            }
        } else {
            this.updateProgress(progressTime);
        }
    }

    public void setSelectedItemSlot(int slot) {
        this.resetProgress();
        this.selectedItemSlot = slot;
    }

    public int getSelectedSlotIndex() {
        return this.selectedItemSlot;
    }

    private void resetProgress() {
        if (this.consumeCardStartTick != -1L) {
            this.consumeCardStartTick = -1L;
            this.updateProgress(-1);
        }
    }

    public int getMaxProcessingTime() {
        return 10;
    }

    private void updateProgress(int value) {
        if (this.progressChangedHandler != null) {
            this.progressChangedHandler.handleProgress(value);
        }
    }

    public void saveChanges() {
        CompoundTag itemTag = new CompoundTag();
        this.input.writeToNBT(itemTag, "input");
        if (!itemTag.m_128456_()) {
            this.getItemStack().m_41700_("generic_nbt", (Tag)itemTag);
        } else {
            this.getItemStack().m_41749_("generic_nbt");
        }
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        CompoundTag itemTag = this.getItemStack().m_41698_("generic_nbt");
        if (this.input == inv) {
            this.input.writeToNBT(itemTag, "input");
        }
        if (!itemTag.m_128456_()) {
            this.getItemStack().m_41700_("generic_nbt", (Tag)itemTag);
        } else {
            this.getItemStack().m_41749_("generic_nbt");
        }
        if (this.invChangeHandler != null) {
            this.invChangeHandler.handleChange(inv, slot);
        }
    }

    public void returnToMainMenu(Player player, ISubMenu iSubMenu) {
        this.returnToMainMenu.accept(player, iSubMenu);
    }

    public ItemStack getMainMenuIcon() {
        return this.getItemStack();
    }

    public void setProgressChangedHandler(ProgressChangedHandler handler) {
        this.progressChangedHandler = handler;
    }

    public void setUpgradeAppliedWatcher(ClientUpdater handler) {
        this.clientUpdater = handler;
    }

    public void setInventoryChangedHandler(InventoryChangedHandler handler) {
        this.invChangeHandler = handler;
    }

    public InternalInventory getInventory() {
        return this.input;
    }

    public String getCloseHotkey() {
        return AAEHotkeysRegistry.Keys.ARMOR_CONFIG.getId();
    }

    @FunctionalInterface
    public static interface ClientUpdater {
        public void updateClient();
    }

    @FunctionalInterface
    public static interface ProgressChangedHandler {
        public void handleProgress(int var1);
    }

    @FunctionalInterface
    public static interface InventoryChangedHandler {
        public void handleChange(InternalInventory var1, int var2);
    }
}

