/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.stacks.AEKey;
import appeng.core.AELog;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.menu.guisync.GuiSync;
import appeng.menu.locator.MenuLocator;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.api.IQuantumCrafterTermMenuHost;
import net.pedroksl.advanced_ae.api.ShowQuantumCrafters;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.helpers.AutoCraftingContainer;
import net.pedroksl.advanced_ae.gui.QuantumCrafterConfigPatternMenu;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.ClearQuantumCrafterTerminalPacket;
import net.pedroksl.advanced_ae.network.packet.QuantumCrafterTerminalClientAction;
import net.pedroksl.advanced_ae.network.packet.QuantumCrafterTerminalPacket;
import org.jetbrains.annotations.Nullable;

public class QuantumCrafterTermMenu
extends AEBaseMenu {
    private final IQuantumCrafterTermMenuHost host;
    @GuiSync(value=1)
    public ShowQuantumCrafters showQuantumCrafters = ShowQuantumCrafters.VISIBLE;
    private static long inventorySerial = Long.MIN_VALUE;
    private final Map<AutoCraftingContainer, ContainerTracker> diList = new IdentityHashMap<AutoCraftingContainer, ContainerTracker>();
    private final Long2ObjectOpenHashMap<ContainerTracker> byId = new Long2ObjectOpenHashMap();
    private final Set<AutoCraftingContainer> pinnedHosts = Collections.newSetFromMap(new IdentityHashMap());

    public QuantumCrafterTermMenu(int id, Inventory playerInventory, IQuantumCrafterTermMenuHost host) {
        this(AAEMenus.QUANTUM_CRAFTER_TERMINAL.get(), id, playerInventory, host, true);
    }

    public QuantumCrafterTermMenu(MenuType<?> menuType, int id, Inventory playerInventory, IQuantumCrafterTermMenuHost host, boolean bindInventory) {
        super(menuType, id, playerInventory, (Object)host);
        this.host = host;
        if (bindInventory) {
            this.createPlayerInventorySlots(playerInventory);
        }
    }

    public ShowQuantumCrafters getShownQuantumCrafters() {
        return this.showQuantumCrafters;
    }

    public void m_38946_() {
        if (this.isClientSide()) {
            return;
        }
        this.showQuantumCrafters = (ShowQuantumCrafters)this.host.getConfigManager().getSetting(AAESettings.TERMINAL_SHOW_QUANTUM_CRAFTERS);
        super.m_38946_();
        if (this.showQuantumCrafters != ShowQuantumCrafters.NOT_FULL) {
            this.pinnedHosts.clear();
        }
        IGrid grid = this.getGrid();
        VisitorState state = new VisitorState();
        if (grid != null) {
            for (Class machineClass : grid.getMachineClasses()) {
                if (!AutoCraftingContainer.class.isAssignableFrom(machineClass)) continue;
                this.visitPatternProviderHosts(grid, machineClass, state);
            }
            this.pinnedHosts.removeIf(host -> host.getGrid() != grid);
        } else {
            this.pinnedHosts.clear();
        }
        if (state.total != this.diList.size() || state.forceFullUpdate) {
            this.sendFullUpdate(grid);
        } else {
            this.sendIncrementalUpdate();
        }
    }

    @Nullable
    private IGrid getGrid() {
        IGridNode agn;
        IActionHost aHost = this.getActionHost();
        if (aHost != null && (agn = aHost.getActionableNode()) != null && agn.isActive()) {
            return agn.getGrid();
        }
        return null;
    }

    private boolean isFull(AutoCraftingContainer logic) {
        for (int i = 0; i < logic.getTerminalPatternInventory().size(); ++i) {
            if (!logic.getTerminalPatternInventory().getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private boolean isVisible(AutoCraftingContainer container) {
        boolean isVisible = container.isVisibleInTerminal();
        return switch (this.getShownQuantumCrafters()) {
            default -> throw new IncompatibleClassChangeError();
            case ShowQuantumCrafters.VISIBLE -> isVisible;
            case ShowQuantumCrafters.NOT_FULL -> {
                if (isVisible && (this.pinnedHosts.contains(container) || !this.isFull(container))) {
                    yield true;
                }
                yield false;
            }
            case ShowQuantumCrafters.ALL -> true;
        };
    }

    private <T extends AutoCraftingContainer> void visitPatternProviderHosts(IGrid grid, Class<T> machineClass, VisitorState state) {
        for (AutoCraftingContainer container : grid.getActiveMachines(machineClass)) {
            ContainerTracker t;
            if (!this.isVisible(container)) continue;
            if (this.getShownQuantumCrafters() == ShowQuantumCrafters.NOT_FULL) {
                this.pinnedHosts.add(container);
            }
            if ((t = this.diList.get(container)) == null) {
                state.forceFullUpdate = true;
            }
            ++state.total;
        }
    }

    public void configPattern(long serverId, int slot) {
        if (this.isClientSide()) {
            AAENetworkHandler.INSTANCE.sendToServer(new QuantumCrafterTerminalClientAction(true, serverId, slot));
            return;
        }
        ContainerTracker inv = (ContainerTracker)this.byId.get(serverId);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            AELog.warn((String)"Client refers to invalid slot %d of inventory %s", (Object[])new Object[]{slot, inv.container});
            return;
        }
        MenuLocator locator = this.getLocator();
        if (locator != null) {
            LinkedHashMap<AEKey, Long> inputs = inv.container.getPatternConfigInputs(slot);
            Pair<AEKey, Long> output = inv.container.getPatternConfigOutput(slot);
            if (inputs == null || output == null) {
                return;
            }
            QuantumCrafterConfigPatternMenu.open((ServerPlayer)this.getPlayer(), locator, inv.container, slot, inputs, output);
        }
    }

    public void toggleEnabledPattern(long serverId, int slot) {
        if (this.isClientSide()) {
            AAENetworkHandler.INSTANCE.sendToServer(new QuantumCrafterTerminalClientAction(false, serverId, slot));
            return;
        }
        ContainerTracker inv = (ContainerTracker)this.byId.get(serverId);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            AELog.warn((String)"Client refers to invalid slot %d of inventory %s", (Object[])new Object[]{slot, inv.container});
            return;
        }
        inv.container.toggleEnablePattern(slot);
    }

    public void doAction(ServerPlayer player, InventoryAction action, int slot, long id) {
        ContainerTracker inv = (ContainerTracker)this.byId.get(id);
        if (inv == null) {
            return;
        }
        if (slot < 0 || slot >= inv.server.size()) {
            AELog.warn((String)"Client refers to invalid slot %d of inventory %s", (Object[])new Object[]{slot, inv.container});
            return;
        }
        ItemStack is = inv.server.getStackInSlot(slot);
        FilteredInternalInventory patternSlot = new FilteredInternalInventory(inv.server.getSlotInv(slot), (IAEItemFilter)new PatternSlotFilter());
        ItemStack carried = this.m_142621_();
        switch (action) {
            case PICKUP_OR_SET_DOWN: {
                if (!carried.m_41619_()) {
                    ItemStack inSlot = patternSlot.getStackInSlot(0);
                    if (inSlot.m_41619_()) {
                        this.m_142503_(patternSlot.addItems(carried));
                        break;
                    }
                    inSlot = inSlot.m_41777_();
                    ItemStack inHand = carried.m_41777_();
                    patternSlot.setItemDirect(0, ItemStack.f_41583_);
                    this.m_142503_(ItemStack.f_41583_);
                    this.m_142503_(patternSlot.addItems(inHand.m_41777_()));
                    if (this.m_142621_().m_41619_()) {
                        this.m_142503_(inSlot);
                        break;
                    }
                    this.m_142503_(inHand);
                    patternSlot.setItemDirect(0, inSlot);
                    break;
                }
                this.m_142503_(patternSlot.getStackInSlot(0));
                patternSlot.setItemDirect(0, ItemStack.f_41583_);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (!carried.m_41619_()) {
                    ItemStack extra = carried.m_41620_(1);
                    if (!extra.m_41619_()) {
                        extra = patternSlot.addItems(extra);
                    }
                    if (extra.m_41619_()) break;
                    carried.m_41769_(extra.m_41613_());
                    break;
                }
                if (is.m_41619_()) break;
                this.m_142503_(patternSlot.extractItem(0, (is.m_41613_() + 1) / 2, false));
                break;
            }
            case SHIFT_CLICK: {
                ItemStack stack = patternSlot.getStackInSlot(0).m_41777_();
                if (!player.m_150109_().m_36054_(stack)) {
                    patternSlot.setItemDirect(0, stack);
                    break;
                }
                patternSlot.setItemDirect(0, ItemStack.f_41583_);
                break;
            }
            case MOVE_REGION: {
                for (int x = 0; x < inv.server.size(); ++x) {
                    ItemStack stack = inv.server.getStackInSlot(x);
                    if (!player.m_150109_().m_36054_(stack)) {
                        patternSlot.setItemDirect(0, stack);
                        continue;
                    }
                    patternSlot.setItemDirect(0, ItemStack.f_41583_);
                }
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.m_150110_().f_35937_ || !carried.m_41619_()) break;
                this.m_142503_(is.m_41619_() ? ItemStack.f_41583_ : is.m_41777_());
            }
        }
    }

    private void sendFullUpdate(@Nullable IGrid grid) {
        this.byId.clear();
        this.diList.clear();
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AAENetworkHandler.INSTANCE.sendTo(new ClearQuantumCrafterTerminalPacket(), serverPlayer);
        }
        if (grid == null) {
            return;
        }
        for (Class machineClass : grid.getMachineClasses()) {
            Class<? extends AutoCraftingContainer> containerClass = QuantumCrafterTermMenu.tryCastMachineToContainer(machineClass);
            if (containerClass == null) continue;
            for (AutoCraftingContainer container : grid.getActiveMachines(containerClass)) {
                if (!this.isVisible(container)) continue;
                this.diList.put(container, new ContainerTracker(container, container.getTerminalPatternInventory(), container.getEnabledPatternSlots(), container.getInvalidPatternSlots()));
            }
        }
        for (ContainerTracker inv : this.diList.values()) {
            this.byId.put(inv.serverId, (Object)inv);
            Player player2 = this.getPlayer();
            if (!(player2 instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player2;
            AAENetworkHandler.INSTANCE.sendTo(inv.createFullPacket(), serverPlayer);
        }
    }

    private void sendIncrementalUpdate() {
        for (ContainerTracker inv : this.diList.values()) {
            Player player;
            QuantumCrafterTerminalPacket packet = inv.createUpdatePacket();
            if (packet == null || !((player = this.getPlayer()) instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AAENetworkHandler.INSTANCE.sendTo(packet, serverPlayer);
        }
    }

    private static Class<? extends AutoCraftingContainer> tryCastMachineToContainer(Class<?> machineClass) {
        if (AutoCraftingContainer.class.isAssignableFrom(machineClass)) {
            return machineClass.asSubclass(AutoCraftingContainer.class);
        }
        return null;
    }

    private static class VisitorState {
        int total;
        boolean forceFullUpdate;

        private VisitorState() {
        }
    }

    private static class ContainerTracker {
        private final AutoCraftingContainer container;
        private final long sortBy;
        private final long serverId = inventorySerial++;
        private final InternalInventory client;
        private final List<Boolean> clientEnabled;
        private final List<Boolean> clientInvalid;
        private final InternalInventory server;
        private final List<Boolean> serverEnabled;
        private final List<Boolean> serverInvalid;

        public ContainerTracker(AutoCraftingContainer container, InternalInventory patterns, List<Boolean> enabledList, List<Boolean> invalidList) {
            this.container = container;
            this.server = patterns;
            this.client = new AppEngInternalInventory(this.server.size());
            this.serverEnabled = enabledList;
            this.clientEnabled = new ArrayList<Boolean>(enabledList);
            this.serverInvalid = invalidList;
            this.clientInvalid = new ArrayList<Boolean>(invalidList);
            this.sortBy = container.getTerminalSortOrder();
        }

        public QuantumCrafterTerminalPacket createFullPacket() {
            Int2ObjectArrayMap slots = new Int2ObjectArrayMap(this.server.size());
            Int2BooleanArrayMap enabledArray = new Int2BooleanArrayMap(this.server.size());
            Int2BooleanArrayMap invalidArray = new Int2BooleanArrayMap(this.server.size());
            for (int i = 0; i < this.server.size(); ++i) {
                ItemStack stack = this.server.getStackInSlot(i);
                if (!stack.m_41619_()) {
                    slots.put(i, (Object)stack);
                }
                enabledArray.put(i, this.serverEnabled.get(i).booleanValue());
                invalidArray.put(i, this.serverInvalid.get(i).booleanValue());
            }
            return QuantumCrafterTerminalPacket.fullUpdate(this.serverId, this.server.size(), this.sortBy, (Int2ObjectMap<ItemStack>)slots, enabledArray, invalidArray);
        }

        @Nullable
        public QuantumCrafterTerminalPacket createUpdatePacket() {
            IntList changedSlots = this.detectChangedSlots();
            if (changedSlots == null) {
                return null;
            }
            Int2ObjectArrayMap slots = new Int2ObjectArrayMap(changedSlots.size());
            Int2BooleanArrayMap enabledArray = new Int2BooleanArrayMap(changedSlots.size());
            Int2BooleanArrayMap invalidArray = new Int2BooleanArrayMap(changedSlots.size());
            for (int i = 0; i < changedSlots.size(); ++i) {
                int slot;
                ItemStack stack = this.server.getStackInSlot(slot = changedSlots.getInt(i));
                this.client.setItemDirect(slot, stack.m_41619_() ? ItemStack.f_41583_ : stack.m_41777_());
                slots.put(slot, (Object)stack);
                Boolean enabled = this.serverEnabled.get(slot);
                this.clientEnabled.set(slot, enabled);
                enabledArray.put(slot, enabled.booleanValue());
                Boolean invalid = this.serverInvalid.get(slot);
                this.clientInvalid.set(slot, invalid);
                invalidArray.put(slot, invalid.booleanValue());
            }
            return QuantumCrafterTerminalPacket.incrementalUpdate(this.serverId, (Int2ObjectMap<ItemStack>)slots, enabledArray, invalidArray);
        }

        @Nullable
        private IntList detectChangedSlots() {
            IntArrayList changedSlots = null;
            for (int x = 0; x < this.server.size(); ++x) {
                if (!ContainerTracker.isDifferent(this.server.getStackInSlot(x), this.client.getStackInSlot(x)) && this.serverEnabled.get(x) == this.clientEnabled.get(x) && this.serverInvalid.get(x) == this.clientInvalid.get(x)) continue;
                if (changedSlots == null) {
                    changedSlots = new IntArrayList();
                }
                changedSlots.add(x);
            }
            return changedSlots;
        }

        private static boolean isDifferent(ItemStack a, ItemStack b) {
            if (a.m_41619_() && b.m_41619_()) {
                return false;
            }
            if (a.m_41619_() || b.m_41619_()) {
                return true;
            }
            return !ItemStack.m_41728_((ItemStack)a, (ItemStack)b);
        }
    }

    private static class PatternSlotFilter
    implements IAEItemFilter {
        private PatternSlotFilter() {
        }

        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return !stack.m_41619_() && PatternDetailsHelper.isEncodedPattern((ItemStack)stack);
        }
    }
}

