/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterScreen;
import net.pedroksl.ae2addonlib.network.AddonPacket;

public class PatternsUpdatePacket
extends AddonPacket {
    private final List<Boolean> invalidPatterns;
    private final List<Boolean> enabledPatterns;

    public PatternsUpdatePacket(FriendlyByteBuf stream) {
        int x;
        ArrayList<Boolean> invalidList = new ArrayList<Boolean>();
        ArrayList<Boolean> enabledList = new ArrayList<Boolean>();
        int size = stream.readInt();
        for (x = 0; x < size; ++x) {
            invalidList.add(stream.readBoolean());
        }
        size = stream.readInt();
        for (x = 0; x < size; ++x) {
            enabledList.add(stream.readBoolean());
        }
        this.invalidPatterns = invalidList;
        this.enabledPatterns = enabledList;
    }

    public PatternsUpdatePacket(List<Boolean> invalidPatterns, List<Boolean> enabledPatterns) {
        this.invalidPatterns = invalidPatterns;
        this.enabledPatterns = enabledPatterns;
    }

    public void write(FriendlyByteBuf stream) {
        stream.writeInt(this.invalidPatterns.size());
        for (Boolean entry : this.invalidPatterns) {
            stream.writeBoolean(entry.booleanValue());
        }
        stream.writeInt(this.enabledPatterns.size());
        for (Boolean entry : this.enabledPatterns) {
            stream.writeBoolean(entry.booleanValue());
        }
    }

    public void clientPacketData(Player player) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof QuantumCrafterScreen) {
            QuantumCrafterScreen screen2 = (QuantumCrafterScreen)screen;
            screen2.updateInvalidButtons(this.invalidPatterns);
            screen2.updateEnabledButtons(this.enabledPatterns);
        }
    }
}

