/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.recipes;

import appeng.api.stacks.GenericStack;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipe;
import net.pedroksl.ae2addonlib.recipes.IngredientStack;
import org.jetbrains.annotations.Nullable;

public class ReactionChamberRecipeSerializer
implements RecipeSerializer<ReactionChamberRecipe> {
    public static final ReactionChamberRecipeSerializer INSTANCE = new ReactionChamberRecipeSerializer();
    public static final Codec<GenericStack> GENERIC_STACK_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)CompoundTag.f_128325_.fieldOf("output").forGetter(GenericStack::writeTag)).apply((Applicative)builder, GenericStack::readTag));

    private ReactionChamberRecipeSerializer() {
    }

    public ReactionChamberRecipe fromJson(ResourceLocation id, JsonObject json) {
        GenericStack output = (GenericStack)GENERIC_STACK_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().get();
        JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"input_items");
        ArrayList<IngredientStack.Item> inputs = new ArrayList<IngredientStack.Item>();
        for (JsonElement element : array) {
            inputs.add(IngredientStack.Item.fromJson((JsonElement)element));
        }
        IngredientStack.Fluid fluid = IngredientStack.Fluid.fromJson((JsonElement)json.get("fluid"));
        int energy = json.get("energy").getAsInt();
        return new ReactionChamberRecipe(id, output, inputs, fluid, energy);
    }

    @Nullable
    public ReactionChamberRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        GenericStack output = (GenericStack)buffer.m_271872_(GENERIC_STACK_CODEC);
        int inputSize = buffer.readInt();
        ArrayList<IngredientStack.Item> inputs = new ArrayList<IngredientStack.Item>();
        for (int i = 0; i < inputSize; ++i) {
            inputs.add(IngredientStack.Item.fromNetwork((FriendlyByteBuf)buffer));
        }
        IngredientStack.Fluid fluid = IngredientStack.Fluid.fromNetwork((FriendlyByteBuf)buffer);
        int energy = buffer.readInt();
        return new ReactionChamberRecipe(id, output, inputs, fluid, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, ReactionChamberRecipe recipe) {
        buffer.m_272073_(GENERIC_STACK_CODEC, (Object)recipe.output);
        buffer.writeInt(recipe.inputs.size());
        for (IngredientStack.Item input : recipe.inputs) {
            input.toNetwork(buffer);
        }
        recipe.fluid.toNetwork(buffer);
        buffer.writeInt(recipe.energy);
    }
}

