/*
 * Decompiled with CFR 0.152.
 */
package dev.beecube31.botaniaasgard.core;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="botaniaasgard", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AFBConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AFB::Config");
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    public static void register(ModLoadingContext context) {
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC, "botania_asgard-common.toml");
        LOGGER.info("Registered COMMON config");
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == COMMON_SPEC) {
            LOGGER.info("Loading COMMON config file: {}", (Object)event.getConfig().getFileName());
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == COMMON_SPEC) {
            LOGGER.info("Reloading COMMON config file: {}", (Object)event.getConfig().getFileName());
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.IntValue asgardManaStorage;
        public final ForgeConfigSpec.IntValue asgardManaGenerationPerTick;
        public final ForgeConfigSpec.IntValue asgardLinkationRadius;
        public final ForgeConfigSpec.IntValue asgardIIManaStorage;
        public final ForgeConfigSpec.IntValue asgardIIManaGenerationPerTick;
        public final ForgeConfigSpec.IntValue asgardIILinkationRadius;
        public final ForgeConfigSpec.IntValue asgardIIIManaStorage;
        public final ForgeConfigSpec.IntValue asgardIIIManaGenerationPerTick;
        public final ForgeConfigSpec.IntValue asgardIIILinkationRadius;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Asgard configuration").push("asgard");
            this.asgardManaStorage = builder.defineInRange("asgardManaStorage", 1000000, 0, Integer.MAX_VALUE);
            this.asgardManaGenerationPerTick = builder.defineInRange("asgardManaGenerationPerTick", 1000000, 0, Integer.MAX_VALUE);
            this.asgardLinkationRadius = builder.defineInRange("asgardLinkationRadius", 32, 0, Integer.MAX_VALUE);
            this.asgardIIManaStorage = builder.defineInRange("asgardIIManaStorage", 10000000, 0, Integer.MAX_VALUE);
            this.asgardIIManaGenerationPerTick = builder.defineInRange("asgardIIManaGenerationPerTick", 2500000, 0, Integer.MAX_VALUE);
            this.asgardIILinkationRadius = builder.defineInRange("asgardIILinkationRadius", 64, 0, Integer.MAX_VALUE);
            this.asgardIIIManaStorage = builder.defineInRange("asgardIIIManaStorage", 100000000, 0, Integer.MAX_VALUE);
            this.asgardIIIManaGenerationPerTick = builder.defineInRange("asgardIIIManaGenerationPerTick", 10000000, 0, Integer.MAX_VALUE);
            this.asgardIIILinkationRadius = builder.defineInRange("asgardIIILinkationRadius", 128, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

