/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.newctm;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.Configurations;
import team.chisel.ctm.client.util.CTMLogic;

public class ConnectionCheck {
    public Optional<Boolean> disableObscuredFaceCheck = Optional.empty();
    protected boolean ignoreStates;
    protected CTMLogic.StateComparisonCallback stateComparator = CTMLogic.StateComparisonCallback.DEFAULT;

    public final boolean isConnected(BlockAndTintGetter world, BlockPos current, BlockState currentState, BlockPos connection, Direction dir) {
        BlockState state = this.getConnectionState(world, current, currentState, dir, connection, world.m_8055_(connection));
        return this.isConnected(world, current, currentState, connection, dir, state);
    }

    public boolean isConnected(BlockAndTintGetter world, BlockPos current, BlockState currentState, BlockPos connection, Direction dir, BlockState state) {
        BlockState obscuring;
        BlockState con = this.getConnectionState(world, connection, world.m_8055_(connection), dir, current, currentState);
        if (this.disableObscuredFaceCheck.orElseGet(Configurations::connectInsideCTM).booleanValue()) {
            obscuring = null;
        } else {
            BlockPos obscuringPos = connection.m_121945_(dir);
            obscuring = this.getConnectionState(world, obscuringPos, world.m_8055_(obscuringPos), dir, current, currentState);
        }
        if (con == null) {
            throw new IllegalStateException("Error, received null blockstate appearance from block " + world.m_8055_(connection));
        }
        boolean ret = this.stateComparator(state, con, dir);
        if (obscuring == null) {
            return ret;
        }
        return ret &= !this.stateComparator(state, obscuring, dir);
    }

    public boolean stateComparator(BlockState from, BlockState to, Direction dir) {
        return this.stateComparator.connects(this, from, to, dir);
    }

    public BlockState getConnectionState(BlockAndTintGetter world, BlockPos pos, @Nullable Direction side, BlockPos connection, BlockState connectionState) {
        return this.getConnectionState(world, pos, world.m_8055_(pos), side, connection, connectionState);
    }

    public BlockState getConnectionState(BlockAndTintGetter world, BlockPos pos, BlockState state, @Nullable Direction side, BlockPos connection, BlockState connectionState) {
        if (side != null) {
            return state.getAppearance(world, pos, side, connectionState, connection);
        }
        return state;
    }

    public boolean ignoreStates() {
        return this.ignoreStates;
    }

    public ConnectionCheck ignoreStates(boolean ignoreStates) {
        this.ignoreStates = ignoreStates;
        return this;
    }

    public CTMLogic.StateComparisonCallback stateComparator() {
        return this.stateComparator;
    }

    public ConnectionCheck stateComparator(CTMLogic.StateComparisonCallback stateComparator) {
        this.stateComparator = stateComparator;
        return this;
    }
}

