/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.type;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.texture.TextureType;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.newctm.ConnectionCheck;
import team.chisel.ctm.client.texture.ctx.TextureContextCTM;
import team.chisel.ctm.client.texture.render.TextureEdges;
import team.chisel.ctm.client.texture.type.TextureTypeCTM;
import team.chisel.ctm.client.util.CTMLogic;
import team.chisel.ctm.client.util.Dir;

@TextureType(value="edges")
public class TextureTypeEdges
extends TextureTypeCTM {
    @Override
    public ICTMTexture<? extends TextureTypeCTM> makeTexture(TextureInfo info) {
        return new TextureEdges(this, info);
    }

    @Override
    public TextureContextCTM getBlockRenderContext(BlockState state, BlockAndTintGetter world, BlockPos pos, ICTMTexture<?> tex) {
        return new TextureContextCTM(state, world, pos, (TextureEdges)tex){

            @Override
            protected CTMLogic createCTM(BlockState state) {
                CTMLogic parent = super.createCTM(state);
                CTMLogicEdges ret = new CTMLogicEdges();
                ret.connectionCheck.ignoreStates(parent.connectionCheck.ignoreStates()).stateComparator(parent.connectionCheck.stateComparator());
                ret.connectionCheck.disableObscuredFaceCheck = parent.connectionCheck.disableObscuredFaceCheck;
                return ret;
            }
        };
    }

    @Override
    public int requiredTextures() {
        return 3;
    }

    public static class ConnectionCheckEdges
    extends ConnectionCheck {
        private boolean obscured;

        @Override
        public boolean isConnected(BlockAndTintGetter world, BlockPos current, BlockState currentState, BlockPos connection, Direction dir, BlockState state) {
            if (this.isObscured()) {
                return false;
            }
            BlockState obscuring = this.getConnectionState(world, current.m_121945_(dir), dir, current, currentState);
            if (this.stateComparator(state, obscuring, dir)) {
                this.setObscured(true);
                return false;
            }
            BlockState con = this.getConnectionState(world, connection, dir, current, currentState);
            BlockState obscuringcon = this.getConnectionState(world, connection.m_121945_(dir), dir, current, currentState);
            if (this.stateComparator(state, con, dir) || this.stateComparator(state, obscuringcon, dir)) {
                Vec3 difference = Vec3.m_82528_((Vec3i)connection.m_121996_((Vec3i)current));
                if (difference.m_82556_() > 1.0) {
                    Vec3 vB;
                    Vec3 vA;
                    difference = difference.m_82541_();
                    if (dir.m_122434_() == Direction.Axis.Z) {
                        difference = difference.m_82524_(-1.5707964f);
                    }
                    float ang = 0.7853982f;
                    if (dir.m_122434_().m_122478_()) {
                        vA = difference.m_82524_(ang);
                        vB = difference.m_82524_(-ang);
                    } else {
                        vA = difference.m_82496_(ang);
                        vB = difference.m_82496_(-ang);
                    }
                    BlockPos posA = BlockPos.m_274446_((Position)vA).m_121955_((Vec3i)current);
                    BlockPos posB = BlockPos.m_274446_((Position)vB).m_121955_((Vec3i)current);
                    return this.getConnectionState(world, posA, dir, current, currentState) == state && !this.stateComparator(state, this.getConnectionState(world, posA.m_121945_(dir), dir, current, currentState), dir) || this.getConnectionState(world, posB, dir, current, currentState) == state && !this.stateComparator(state, this.getConnectionState(world, posB.m_121945_(dir), dir, current, currentState), dir);
                }
                return true;
            }
            return false;
        }

        public void setObscured(boolean obscured) {
            this.obscured = obscured;
        }

        public boolean isObscured() {
            return this.obscured;
        }
    }

    @ParametersAreNonnullByDefault
    public static class CTMLogicEdges
    extends CTMLogic {
        public CTMLogicEdges() {
            this.connectionCheck = new ConnectionCheckEdges();
        }

        @Override
        protected void fillSubmaps(int idx) {
            Dir[] dirs = submapMap[idx];
            if (!this.connectedOr(dirs[0], dirs[1]) && this.connected(dirs[2])) {
                this.submapCache[idx] = submapOffsets[idx];
            } else {
                super.fillSubmaps(idx);
            }
        }

        @Override
        public long serialized() {
            return this.isObscured() ? super.serialized() | 0x100L : super.serialized();
        }

        public boolean isObscured() {
            return ((ConnectionCheckEdges)this.connectionCheck).isObscured();
        }
    }
}

