/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.client.util.Quad;

public class PartialTextureAtlasSprite
extends TextureAtlasSprite {
    private final float u0;
    private final float u1;
    private final float v0;
    private final float v1;

    public static TextureAtlasSprite createPartial(TextureAtlasSprite sprite, ISubmap submap) {
        if ((submap = submap.unitScale()).getXOffset() == 0.0f && submap.getYOffset() == 0.0f && submap.getWidth() == 1.0f && submap.getHeight() == 1.0f) {
            return sprite;
        }
        float width = sprite.m_118410_() - sprite.m_118409_();
        float height = sprite.m_118412_() - sprite.m_118411_();
        float atlasWidth = (float)sprite.m_245424_().m_246492_() / width;
        float atlasHeight = (float)sprite.m_245424_().m_245330_() / height;
        float uWidth = width * submap.getWidth();
        float vHeight = height * submap.getHeight();
        float xOffset = Quad.lerp(sprite.m_118409_(), sprite.m_118410_(), submap.getXOffset());
        float yOffset = Quad.lerp(sprite.m_118411_(), sprite.m_118412_(), submap.getYOffset());
        return new PartialTextureAtlasSprite(sprite, atlasWidth, atlasHeight, xOffset, uWidth, yOffset, vHeight);
    }

    protected PartialTextureAtlasSprite(TextureAtlasSprite sprite, float atlasWidth, float atlasHeight, float xOffset, float uWidth, float yOffset, float vHeight) {
        super(sprite.m_247685_(), sprite.m_245424_(), (int)atlasWidth, (int)atlasHeight, sprite.m_174743_(), sprite.m_174744_());
        this.u0 = xOffset;
        this.u1 = xOffset + uWidth;
        this.v0 = yOffset;
        this.v1 = yOffset + vHeight;
    }

    public float m_118409_() {
        return this.u0;
    }

    public float m_118410_() {
        return this.u1;
    }

    public float m_118367_(double u) {
        float width = this.m_118410_() - this.m_118409_();
        return (float)((double)this.m_118409_() + (double)width * u);
    }

    public float m_174727_(float offset) {
        float width = this.m_118410_() - this.m_118409_();
        return (offset - this.m_118409_()) / width;
    }

    public float m_118411_() {
        return this.v0;
    }

    public float m_118412_() {
        return this.v1;
    }

    public float m_118393_(double v) {
        float height = this.m_118412_() - this.m_118411_();
        return (float)((double)this.m_118411_() + (double)height * v);
    }

    public float m_174741_(float offset) {
        float height = this.m_118412_() - this.m_118411_();
        return (offset - this.m_118411_()) / height;
    }

    public String toString() {
        return "PartialTextureAtlasSprite{contents='" + this.m_245424_() + "', u0=" + this.m_118409_() + ", u1=" + this.m_118410_() + ", v0=" + this.m_118411_() + ", v1=" + this.m_118412_() + "}";
    }

    private float m_118366_() {
        float atlasWidth = (float)this.m_245424_().m_246492_() / (this.m_118410_() - this.m_118409_());
        float atlasHeight = (float)this.m_245424_().m_245330_() / (this.m_118412_() - this.m_118411_());
        return Math.max(atlasWidth, atlasHeight);
    }

    public float m_118417_() {
        return 4.0f / this.m_118366_();
    }
}

