/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.client.util.CTMLogic;
import team.chisel.ctm.client.util.Submap;
import team.chisel.ctm.client.util.VertexData;

@ParametersAreNonnullByDefault
public class Quad {
    @Deprecated
    public static final ISubmap TOP_LEFT = Submap.fromPixelScale(7.8f, 7.8f, 0.0f, 0.0f);
    @Deprecated
    public static final ISubmap TOP_RIGHT = Submap.fromPixelScale(7.8f, 7.8f, 8.2f, 0.0f);
    @Deprecated
    public static final ISubmap BOTTOM_LEFT = Submap.fromPixelScale(7.8f, 7.8f, 0.0f, 8.2f);
    @Deprecated
    public static final ISubmap BOTTOM_RIGHT = Submap.fromPixelScale(7.8f, 7.8f, 8.2f, 8.2f);
    private final VertexData[] vertices;
    private UVs uvs;
    private final Builder builder;

    private Quad(VertexData[] vertices, Builder builder, TextureAtlasSprite sprite) {
        this.vertices = vertices;
        this.builder = builder;
        Vec2[] uvs = new Vec2[this.vertices.length];
        for (int i = 0; i < uvs.length; ++i) {
            uvs[i] = this.vertices[i].getUV();
        }
        this.uvs = new UVs(sprite, uvs);
    }

    private VertexData[] copyVertices() {
        VertexData[] verticesCopy = new VertexData[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            verticesCopy[i] = this.vertices[i].copy(false);
        }
        return verticesCopy;
    }

    public Vector3f getVert(int index) {
        VertexData vertex = this.vertices[index % this.vertices.length];
        return new Vector3f(vertex.getPosX(), vertex.getPosY(), vertex.getPosZ());
    }

    public Quad withVert(int index, Vector3f vert) {
        Preconditions.checkElementIndex((int)index, (int)this.vertices.length, (String)"Vertex index out of range!");
        VertexData[] newVertices = this.copyVertices();
        newVertices[index].pos(vert.x, vert.y, vert.z);
        return new Quad(newVertices, this.builder, this.getUvs().getSprite());
    }

    public Vec2 getUv(int index) {
        return this.vertices[index % this.vertices.length].getUV();
    }

    public Quad withUv(int index, Vec2 uv) {
        Preconditions.checkElementIndex((int)index, (int)this.vertices.length, (String)"UV index out of range!");
        VertexData[] newVertices = this.copyVertices();
        newVertices[index].texRaw(uv.f_82470_, uv.f_82471_);
        return new Quad(newVertices, this.builder, this.getUvs().getSprite());
    }

    @Deprecated
    public Quad[] subdivide(int count) {
        if (count == 1) {
            return new Quad[]{this};
        }
        if (count != 4) {
            throw new UnsupportedOperationException();
        }
        return this.subsectAll(Submap.X2);
    }

    public Quad[] subsectAll(ISubmap[][] submaps) {
        int stride = submaps[0].length;
        Quad[] ret = new Quad[submaps.length * stride];
        for (int i = 0; i < submaps.length; ++i) {
            System.arraycopy(this.subsectAll(submaps[i]), 0, ret, i * stride, stride);
        }
        return ret;
    }

    public Quad[] subsectAll(ISubmap[] submaps) {
        Quad[] ret = new Quad[submaps.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.subsect(submaps[i]);
        }
        return ret;
    }

    public Quad subsect(ISubmap submap) {
        int firstIndex = 0;
        for (int i = 0; i < this.vertices.length; ++i) {
            VertexData vertex = this.vertices[i];
            if (vertex.getTexV() != this.getUvs().minV || vertex.getTexU() != this.getUvs().minU) continue;
            firstIndex = i;
            break;
        }
        Vector3f[] positions = new Vector3f[this.vertices.length];
        float[][] uvs = new float[this.vertices.length][];
        for (int i = 0; i < this.vertices.length; ++i) {
            int idx = (firstIndex + i) % this.vertices.length;
            VertexData vertex = this.vertices[idx];
            positions[i] = vertex.getPos();
            uvs[i] = new float[]{vertex.getTexU(), vertex.getTexV()};
        }
        Vector3f origin = positions[0];
        Vector3f n1 = positions[1].sub((Vector3fc)origin, new Vector3f());
        Vector3f n2 = positions[2].sub((Vector3fc)origin, new Vector3f());
        Vector3f normalVec = n1.cross((Vector3fc)n2, new Vector3f()).normalize();
        Direction normal = Direction.m_122372_((float)normalVec.x, (float)normalVec.y, (float)normalVec.z);
        TextureAtlasSprite sprite = this.getUvs().getSprite();
        float[][] xy = new float[positions.length][2];
        float[][] newXy = new float[positions.length][2];
        block12: for (int i = 0; i < positions.length; ++i) {
            switch (normal.m_122434_()) {
                case Y: {
                    xy[i][0] = positions[i].x;
                    xy[i][1] = positions[i].z;
                    continue block12;
                }
                case Z: {
                    xy[i][0] = positions[i].x;
                    xy[i][1] = positions[i].y;
                    continue block12;
                }
                case X: {
                    xy[i][0] = positions[i].z;
                    xy[i][1] = positions[i].y;
                }
            }
        }
        if (normal.m_122434_() != Direction.Axis.Y) {
            submap = submap.flipY();
        }
        if (normal == Direction.EAST || normal == Direction.NORTH) {
            submap = submap.flipX();
        }
        submap = submap.unitScale();
        if (normal.m_122434_() == Direction.Axis.Y || normal == Direction.SOUTH || normal == Direction.WEST) {
            newXy[0][0] = Math.max(xy[0][0], submap.getXOffset());
            newXy[1][0] = Math.max(xy[1][0], submap.getXOffset());
            newXy[2][0] = Math.min(xy[2][0], submap.getXOffset() + submap.getWidth());
            newXy[3][0] = Math.min(xy[3][0], submap.getXOffset() + submap.getWidth());
        } else {
            newXy[0][0] = Math.min(xy[0][0], submap.getXOffset() + submap.getWidth());
            newXy[1][0] = Math.min(xy[1][0], submap.getXOffset() + submap.getWidth());
            newXy[2][0] = Math.max(xy[2][0], submap.getXOffset());
            newXy[3][0] = Math.max(xy[3][0], submap.getXOffset());
        }
        if (normal != Direction.UP) {
            newXy[0][1] = Math.min(xy[0][1], submap.getYOffset() + submap.getHeight());
            newXy[1][1] = Math.max(xy[1][1], submap.getYOffset());
            newXy[2][1] = Math.max(xy[2][1], submap.getYOffset());
            newXy[3][1] = Math.min(xy[3][1], submap.getYOffset() + submap.getHeight());
        } else {
            newXy[0][1] = Math.max(xy[0][1], submap.getYOffset());
            newXy[1][1] = Math.min(xy[1][1], submap.getYOffset() + submap.getHeight());
            newXy[2][1] = Math.min(xy[2][1], submap.getYOffset() + submap.getHeight());
            newXy[3][1] = Math.max(xy[3][1], submap.getYOffset());
        }
        float u0Interp = Quad.normalize(xy[0][0], xy[3][0], newXy[0][0]);
        float v0Interp = Quad.normalize(xy[0][1], xy[1][1], newXy[0][1]);
        float u1Interp = Quad.normalize(xy[1][0], xy[2][0], newXy[1][0]);
        float v1Interp = Quad.normalize(xy[1][1], xy[0][1], newXy[1][1]);
        float u2Interp = Quad.normalize(xy[2][0], xy[1][0], newXy[2][0]);
        float v2Interp = Quad.normalize(xy[2][1], xy[3][1], newXy[2][1]);
        float u3Interp = Quad.normalize(xy[3][0], xy[0][0], newXy[3][0]);
        float v3Interp = Quad.normalize(xy[3][1], xy[2][1], newXy[3][1]);
        VertexData[] newVertices = this.copyVertices();
        newVertices[0].texRaw(Quad.lerp(uvs[0][0], uvs[3][0], u0Interp), Quad.lerp(uvs[0][1], uvs[1][1], v0Interp));
        newVertices[1].texRaw(Quad.lerp(uvs[1][0], uvs[2][0], u1Interp), Quad.lerp(uvs[1][1], uvs[0][1], v1Interp));
        newVertices[2].texRaw(Quad.lerp(uvs[2][0], uvs[1][0], u2Interp), Quad.lerp(uvs[2][1], uvs[3][1], v2Interp));
        newVertices[3].texRaw(Quad.lerp(uvs[3][0], uvs[0][0], u3Interp), Quad.lerp(uvs[3][1], uvs[2][1], v3Interp));
        block13: for (int i = 0; i < newVertices.length; ++i) {
            VertexData newVertex = newVertices[i];
            switch (normal.m_122434_()) {
                case Y: {
                    newVertex.pos(newXy[i][0], newVertex.getPosY(), newXy[i][1]);
                    continue block13;
                }
                case Z: {
                    newVertex.pos(newXy[i][0], newXy[i][1], newVertex.getPosZ());
                    continue block13;
                }
                case X: {
                    newVertex.pos(newVertex.getPosX(), newXy[i][1], newXy[i][0]);
                }
            }
        }
        return new Quad(newVertices, this.builder, sprite);
    }

    public static float lerp(float a, float b, float f) {
        return a * (1.0f - f) + b * f;
    }

    public static float normalize(float min, float max, float x) {
        if (min == max) {
            return 0.5f;
        }
        return Mth.m_184655_((float)x, (float)min, (float)max);
    }

    private static float normalize(double min, double max, double x) {
        if (min == max) {
            return 0.5f;
        }
        return (float)Mth.m_14112_((double)x, (double)min, (double)max);
    }

    public Quad rotate(int amount) {
        VertexData[] vertexCopy = this.copyVertices();
        TextureAtlasSprite s = this.getUvs().getSprite();
        for (VertexData vertex : vertexCopy) {
            Vec2 normalized = new Vec2(Quad.normalize(s.m_118409_(), s.m_118410_(), vertex.getTexU()), Quad.normalize(s.m_118411_(), s.m_118412_(), vertex.getTexV()));
            switch (amount) {
                case 1: {
                    vertex.texRaw(normalized.f_82471_, 1.0f - normalized.f_82470_);
                    break;
                }
                case 2: {
                    vertex.texRaw(1.0f - normalized.f_82470_, 1.0f - normalized.f_82471_);
                    break;
                }
                case 3: {
                    vertex.texRaw(1.0f - normalized.f_82471_, normalized.f_82470_);
                    break;
                }
                default: {
                    vertex.texRaw(normalized.f_82470_, normalized.f_82471_);
                }
            }
            vertex.texRaw(Quad.lerp(s.m_118409_(), s.m_118410_(), vertex.getTexU()), Quad.lerp(s.m_118411_(), s.m_118412_(), vertex.getTexV()));
        }
        return new Quad(vertexCopy, this.builder, s);
    }

    public Quad derotate() {
        int start = 0;
        for (int i = 0; i < this.vertices.length; ++i) {
            VertexData vertex = this.vertices[i];
            if (!(vertex.getTexU() <= this.getUvs().minU) || !(vertex.getTexV() <= this.getUvs().minV)) continue;
            start = i;
            break;
        }
        VertexData[] vertexCopy = this.copyVertices();
        for (int i = 0; i < this.vertices.length; ++i) {
            VertexData vertex = this.vertices[(i + start) % this.vertices.length];
            vertexCopy[i].texRaw(vertex.getTexU(), vertex.getTexV());
        }
        return new Quad(vertexCopy, this.builder, this.getUvs().getSprite());
    }

    public Quad setLight(int blockLight, int skyLight) {
        VertexData[] vertexCopy;
        for (VertexData vertexData : vertexCopy = this.copyVertices()) {
            vertexData.light(Math.max(vertexData.getBlockLight(), blockLight), Math.max(vertexData.getSkyLight(), skyLight));
        }
        return new Quad(vertexCopy, this.builder, this.getUvs().getSprite());
    }

    public BakedQuad rebake() {
        QuadBakingVertexConsumer.Buffered builder = new QuadBakingVertexConsumer.Buffered();
        builder.setDirection(this.builder.quadOrientation);
        builder.setTintIndex(this.builder.quadTint);
        builder.setShade(this.builder.applyDiffuseLighting);
        builder.setHasAmbientOcclusion(this.builder.applyAmbientOcclusion);
        builder.setSprite(this.uvs.getSprite());
        for (VertexData vertex : this.vertices) {
            vertex.write((VertexConsumer)builder);
        }
        return builder.getQuad();
    }

    public Quad transformUVs(TextureAtlasSprite sprite) {
        return this.transformUVs(sprite, CTMLogic.FULL_TEXTURE.pixelScale());
    }

    public Quad transformUVs(TextureAtlasSprite sprite, ISubmap submap) {
        return this.withUVs(this.getUvs().transform(sprite, submap));
    }

    public Quad setUVs(TextureAtlasSprite sprite, ISubmap submap) {
        return this.withUVs(this.sample(sprite, submap));
    }

    private UVs sample(TextureAtlasSprite sprite, ISubmap submap) {
        submap = submap.unitScale();
        float width = sprite.m_118410_() - sprite.m_118409_();
        float height = sprite.m_118412_() - sprite.m_118411_();
        return new UVs(Submap.raw(width * submap.getWidth(), height * submap.getHeight(), Quad.lerp(sprite.m_118409_(), sprite.m_118410_(), submap.getXOffset()), Quad.lerp(sprite.m_118411_(), sprite.m_118412_(), submap.getYOffset())), sprite);
    }

    public Quad grow() {
        return this.withUVs(this.getUvs().normalizeQuadrant());
    }

    private Quad withUVs(UVs uvs) {
        VertexData[] vertexCopy = this.copyVertices();
        Vec2[] vectorizedUVs = uvs.vectorize();
        for (int i = 0; i < vertexCopy.length; ++i) {
            vertexCopy[i].texRaw(vectorizedUVs[i].f_82470_, vectorizedUVs[i].f_82471_);
        }
        return new Quad(vertexCopy, this.builder, uvs.getSprite());
    }

    @Deprecated
    public Quad setFullbright(boolean fullbright) {
        return fullbright ? this.setLight(15, 15) : this;
    }

    public static Quad from(BakedQuad baked) {
        Builder b = new Builder(baked.m_173410_());
        b.copyFrom(baked);
        return b.build();
    }

    public String toString() {
        return "Quad(vertices=" + Arrays.deepToString(this.vertices) + ")";
    }

    public UVs getUvs() {
        return this.uvs;
    }

    public static class Builder
    implements VertexConsumer {
        private final TextureAtlasSprite sprite;
        private int quadTint = -1;
        private Direction quadOrientation;
        private boolean applyDiffuseLighting;
        private boolean applyAmbientOcclusion;
        private final VertexData[] vertices = new VertexData[4];
        private boolean building = false;
        private int vertexIndex = 0;

        public void copyFrom(BakedQuad baked) {
            this.setQuadTint(baked.m_111305_());
            this.setQuadOrientation(baked.m_111306_());
            this.setApplyDiffuseLighting(baked.m_111307_());
            this.setApplyAmbientOcclusion(baked.hasAmbientOcclusion());
            this.putBulkData(new PoseStack().m_85850_(), baked, 1.0f, 1.0f, 1.0f, 1.0f, 0, OverlayTexture.f_118083_, true);
        }

        public Quad build() {
            if (!this.building || ++this.vertexIndex != 4) {
                throw new IllegalStateException("Not enough vertices available. Vertices in buffer: " + this.vertexIndex);
            }
            return new Quad(this.vertices, this, this.getSprite());
        }

        @NotNull
        public VertexConsumer m_5483_(double x, double y, double z) {
            if (this.building && ++this.vertexIndex > 4) {
                throw new IllegalStateException("Expected quad export after fourth vertex");
            }
            this.building = true;
            this.vertices[this.vertexIndex] = new VertexData().pos((float)x, (float)y, (float)z);
            return this;
        }

        @NotNull
        public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
            this.vertices[this.vertexIndex].color(red, green, blue, alpha);
            return this;
        }

        @NotNull
        public VertexConsumer m_7421_(float u, float v) {
            this.vertices[this.vertexIndex].texRaw(u, v);
            return this;
        }

        @NotNull
        public VertexConsumer m_7122_(int u, int v) {
            this.vertices[this.vertexIndex].overlay(u, v);
            return this;
        }

        @NotNull
        public VertexConsumer m_7120_(int u, int v) {
            this.vertices[this.vertexIndex].lightRaw(u, v);
            return this;
        }

        @NotNull
        public VertexConsumer m_5601_(float x, float y, float z) {
            this.vertices[this.vertexIndex].normal(x, y, z);
            return this;
        }

        public void m_5752_() {
        }

        public void m_7404_(int r, int g, int b, int a) {
        }

        public void m_141991_() {
        }

        public VertexConsumer misc(VertexFormatElement element, int ... rawData) {
            this.vertices[this.vertexIndex].misc(element, Arrays.copyOf(rawData, rawData.length));
            return this;
        }

        public Builder(TextureAtlasSprite sprite) {
            this.sprite = sprite;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public void setQuadTint(int quadTint) {
            this.quadTint = quadTint;
        }

        public void setQuadOrientation(Direction quadOrientation) {
            this.quadOrientation = quadOrientation;
        }

        public void setApplyDiffuseLighting(boolean applyDiffuseLighting) {
            this.applyDiffuseLighting = applyDiffuseLighting;
        }

        public void setApplyAmbientOcclusion(boolean applyAmbientOcclusion) {
            this.applyAmbientOcclusion = applyAmbientOcclusion;
        }
    }

    public static class UVs
    implements ISubmap {
        private float minU;
        private float minV;
        private float maxU;
        private float maxV;
        private final TextureAtlasSprite sprite;
        private final Vec2[] data;

        private UVs(TextureAtlasSprite sprite, Vec2 ... data) {
            this.data = data;
            this.sprite = sprite;
            float minU = Float.MAX_VALUE;
            float minV = Float.MAX_VALUE;
            float maxU = 0.0f;
            float maxV = 0.0f;
            for (Vec2 v : data) {
                minU = Math.min(minU, v.f_82470_);
                minV = Math.min(minV, v.f_82471_);
                maxU = Math.max(maxU, v.f_82470_);
                maxV = Math.max(maxV, v.f_82471_);
            }
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
        }

        public UVs(float minU, float minV, float maxU, float maxV, TextureAtlasSprite sprite) {
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
            this.sprite = sprite;
            this.data = this.vectorize();
        }

        public UVs(ISubmap submap, TextureAtlasSprite sprite) {
            this(submap.getXOffset(), submap.getYOffset(), submap.getXOffset() + submap.getWidth(), submap.getYOffset() + submap.getHeight(), sprite);
        }

        public UVs transform(TextureAtlasSprite other, ISubmap submap) {
            UVs normal = this.normalize();
            submap = submap.unitScale();
            float width = normal.maxU - normal.minU;
            float height = normal.maxV - normal.minV;
            float minU = submap.getXOffset();
            float minV = submap.getYOffset();
            float maxU = (minU += normal.minU * submap.getWidth()) + width * submap.getWidth();
            float maxV = (minV += normal.minV * submap.getHeight()) + height * submap.getHeight();
            return new UVs(other, new Vec2(this.data[0].f_82470_ == this.minU ? minU : maxU, this.data[0].f_82471_ == this.minV ? minV : maxV), new Vec2(this.data[1].f_82470_ == this.minU ? minU : maxU, this.data[1].f_82471_ == this.minV ? minV : maxV), new Vec2(this.data[2].f_82470_ == this.minU ? minU : maxU, this.data[2].f_82471_ == this.minV ? minV : maxV), new Vec2(this.data[3].f_82470_ == this.minU ? minU : maxU, this.data[3].f_82471_ == this.minV ? minV : maxV)).relativize();
        }

        UVs normalizeQuadrant() {
            UVs normal = this.normalize();
            int quadrant = normal.getQuadrant();
            float minUInterp = quadrant == 1 || quadrant == 2 ? 0.5f : 0.0f;
            float minVInterp = quadrant < 2 ? 0.5f : 0.0f;
            float maxUInterp = quadrant == 0 || quadrant == 3 ? 0.5f : 1.0f;
            float maxVInterp = quadrant > 1 ? 0.5f : 1.0f;
            normal = new UVs(this.sprite, this.normalize(new Vec2(minUInterp, minVInterp), new Vec2(maxUInterp, maxVInterp), normal.vectorize()));
            return normal.relativize();
        }

        public UVs normalize() {
            Vec2 min = new Vec2(this.sprite.m_118409_(), this.sprite.m_118411_());
            Vec2 max = new Vec2(this.sprite.m_118410_(), this.sprite.m_118412_());
            return new UVs(this.sprite, this.normalize(min, max, this.data));
        }

        public UVs relativize() {
            return this.relativize(this.sprite);
        }

        public UVs relativize(TextureAtlasSprite sprite) {
            Vec2 min = new Vec2(sprite.m_118409_(), sprite.m_118411_());
            Vec2 max = new Vec2(sprite.m_118410_(), sprite.m_118412_());
            return new UVs(sprite, this.lerp(min, max, this.data));
        }

        public Vec2[] vectorize() {
            Vec2[] vec2Array;
            if (this.data == null) {
                Vec2[] vec2Array2 = new Vec2[4];
                vec2Array2[0] = new Vec2(this.minU, this.minV);
                vec2Array2[1] = new Vec2(this.minU, this.maxV);
                vec2Array2[2] = new Vec2(this.maxU, this.maxV);
                vec2Array = vec2Array2;
                vec2Array2[3] = new Vec2(this.maxU, this.minV);
            } else {
                vec2Array = this.data;
            }
            return vec2Array;
        }

        private Vec2[] normalize(Vec2 min, Vec2 max, Vec2 ... vecs) {
            Vec2[] ret = new Vec2[vecs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.normalize(min, max, vecs[i]);
            }
            return ret;
        }

        private Vec2 normalize(Vec2 min, Vec2 max, Vec2 vec) {
            return new Vec2(Quad.normalize(min.f_82470_, max.f_82470_, vec.f_82470_), Quad.normalize(min.f_82471_, max.f_82471_, vec.f_82471_));
        }

        private Vec2[] lerp(Vec2 min, Vec2 max, Vec2 ... vecs) {
            Vec2[] ret = new Vec2[vecs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.lerp(min, max, vecs[i]);
            }
            return ret;
        }

        private Vec2 lerp(Vec2 min, Vec2 max, Vec2 vec) {
            return new Vec2(Quad.lerp(min.f_82470_, max.f_82470_, vec.f_82470_), Quad.lerp(min.f_82471_, max.f_82471_, vec.f_82471_));
        }

        public int getQuadrant() {
            if (this.maxU <= 0.5f) {
                return this.maxV <= 0.5f ? 3 : 0;
            }
            return this.maxV <= 0.5f ? 2 : 1;
        }

        @Override
        public float getYOffset() {
            return this.minV;
        }

        @Override
        public float getXOffset() {
            return this.minU;
        }

        @Override
        public float getWidth() {
            return this.maxU - this.minU;
        }

        @Override
        public float getHeight() {
            return this.maxV - this.minV;
        }

        @Override
        public ISubmap unitScale() {
            return this;
        }

        @Override
        public ISubmap pixelScale() {
            return new ISubmap.SubmapRescaled(this, 16.0f, true);
        }

        public String toString() {
            return "Quad.UVs(minU=" + this.getMinU() + ", minV=" + this.getMinV() + ", maxU=" + this.getMaxU() + ", maxV=" + this.getMaxV() + ", sprite=" + this.getSprite() + ", data=" + Arrays.deepToString(this.data) + ")";
        }

        public float getMinU() {
            return this.minU;
        }

        public float getMinV() {
            return this.minV;
        }

        public float getMaxU() {
            return this.maxU;
        }

        public float getMaxV() {
            return this.maxV;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }
    }

    public record Vertex(Vector3f pos, Vec2 uvs) {
    }
}

