/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.gson.JsonParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;

public final class ResourceUtil {
    private static final Map<ResourceLocation, IMetadataSectionCTM> metadataCache = new HashMap<ResourceLocation, IMetadataSectionCTM>();
    private static final IMetadataSectionCTM.Serializer SERIALIZER = new IMetadataSectionCTM.Serializer();

    public static Resource getResource(TextureAtlasSprite sprite) throws IOException {
        return ResourceUtil.getResource(ResourceUtil.spriteToAbsolute(sprite.m_245424_().m_246162_()));
    }

    public static ResourceLocation spriteToAbsolute(ResourceLocation sprite) {
        if (!sprite.m_135815_().startsWith("textures/")) {
            sprite = sprite.m_246208_("textures/");
        }
        if (!sprite.m_135815_().endsWith(".png")) {
            sprite = sprite.m_266382_(".png");
        }
        return sprite;
    }

    public static Resource getResource(ResourceLocation res) throws FileNotFoundException {
        return Minecraft.m_91087_().m_91098_().m_215593_(res);
    }

    public static Resource getResourceUnsafe(ResourceLocation res) {
        try {
            return ResourceUtil.getResource(res);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<IMetadataSectionCTM> getMetadata(ResourceLocation res) throws IOException {
        Optional ret;
        if (metadataCache.containsKey(res)) {
            return Optional.ofNullable(metadataCache.get(res));
        }
        try {
            Resource resource = ResourceUtil.getResource(res);
            ret = resource.m_215509_().m_214059_((MetadataSectionSerializer)SERIALIZER);
        }
        catch (FileNotFoundException e) {
            ret = Optional.empty();
        }
        catch (JsonParseException e) {
            throw new IOException("Error loading metadata for location " + res, e);
        }
        ret.ifPresentOrElse(r -> metadataCache.put(res, (IMetadataSectionCTM)r), () -> metadataCache.put(res, null));
        return ret;
    }

    public static Optional<IMetadataSectionCTM> getMetadata(TextureAtlasSprite sprite) throws IOException {
        return ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(sprite.m_245424_().m_246162_()));
    }

    public static Optional<IMetadataSectionCTM> getMetadataUnsafe(TextureAtlasSprite sprite) {
        try {
            return ResourceUtil.getMetadata(sprite);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void invalidateCaches() {
        metadataCache.clear();
    }

    private ResourceUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

