/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.packet.SendPlayerAdvancementUnlockedPacket;

public class RequestPlayerAdvancementUnlockedPacket
extends PacketCodec {
    @CodecField
    private String advancementId;

    public RequestPlayerAdvancementUnlockedPacket() {
    }

    public RequestPlayerAdvancementUnlockedPacket(String advancementId) {
        this.advancementId = advancementId;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(net.minecraft.world.level.Level level, Player player) {
    }

    @Override
    public void actionServer(net.minecraft.world.level.Level level, ServerPlayer player) {
        Advancement advancement = AdvancementHelpers.getAdvancement(Dist.DEDICATED_SERVER, new ResourceLocation(this.advancementId));
        if (advancement == null) {
            CyclopsCore.clog(Level.ERROR, "Received an invalid advancement " + this.advancementId + " from " + String.valueOf(player.m_7755_()));
            return;
        }
        CyclopsCore._instance.getPacketHandler().sendToPlayer(new SendPlayerAdvancementUnlockedPacket(this.advancementId, AdvancementHelpers.hasAdvancementUnlocked((Player)player, advancement)), player);
    }
}

