/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.util;

import com.google.common.collect.Lists;
import fuzs.enchantinginfuser.api.EnchantingInfuserAPI;
import fuzs.enchantinginfuser.core.CommonAbstractions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class EnchantmentUtil {
    public static List<Enchantment> getAvailableEnchantments(ItemStack stack, boolean allowAnvil, boolean allowTreasure, boolean allowUndiscoverable, boolean allowUntradeable, boolean allowCurse) {
        ArrayList list = Lists.newArrayList();
        boolean book = stack.m_41720_() instanceof BookItem || stack.m_41720_() instanceof EnchantedBookItem;
        for (Enchantment enchantment : BuiltInRegistries.f_256876_) {
            if (!(!allowAnvil ? CommonAbstractions.INSTANCE.canApplyAtEnchantingTable(enchantment, stack) : enchantment.m_6081_(stack))) {
                if (!book || !CommonAbstractions.INSTANCE.isAllowedOnBooks(enchantment)) continue;
            }
            if (!EnchantingInfuserAPI.getEnchantStatsProvider().isDiscoverable(enchantment) ? !allowUndiscoverable : (!EnchantingInfuserAPI.getEnchantStatsProvider().isTradeable(enchantment) ? !allowUntradeable : (EnchantingInfuserAPI.getEnchantStatsProvider().isCurse(enchantment) ? !allowCurse : EnchantingInfuserAPI.getEnchantStatsProvider().isTreasureOnly(enchantment) && !allowTreasure))) continue;
            list.add(enchantment);
        }
        return list;
    }

    public static Map<Enchantment, Integer> copyEnchantmentsToMap(ItemStack stack, List<Enchantment> enchantments) {
        Map<Enchantment, Integer> enchantmentsToLevel = enchantments.stream().collect(Collectors.toMap(Function.identity(), enchantment -> 0));
        if (stack.m_41793_() || stack.m_41720_() instanceof EnchantedBookItem) {
            for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
                if (!enchantmentsToLevel.containsKey(entry.getKey())) continue;
                enchantmentsToLevel.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
            }
        }
        return enchantmentsToLevel;
    }

    public static ItemStack setNewEnchantments(ItemStack stack, Map<Enchantment, Integer> newEnchantments, boolean increaseRepairCost) {
        for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)stack).entrySet()) {
            if (newEnchantments.containsKey(entry.getKey())) continue;
            newEnchantments.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
        }
        Map<Enchantment, Integer> enchantmentsToLevel = newEnchantments.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ItemStack newStack = EnchantmentUtil.getNewEnchantmentStack(stack, !enchantmentsToLevel.isEmpty(), true);
        newStack.m_41749_("Enchantments");
        newStack.m_41749_("StoredEnchantments");
        EnchantmentHelper.m_44865_(enchantmentsToLevel, (ItemStack)newStack);
        if (increaseRepairCost) {
            newStack.m_41742_(AnvilMenu.m_39025_((int)stack.m_41610_()));
        }
        return newStack;
    }

    public static ItemStack getNewEnchantmentStack(ItemStack stack, boolean enchanted, boolean copyResult) {
        ItemStack newStack;
        if (stack.m_41720_() instanceof EnchantedBookItem && !enchanted) {
            newStack = new ItemStack((ItemLike)Items.f_42517_);
        } else if (stack.m_41720_() instanceof BookItem && enchanted) {
            newStack = new ItemStack((ItemLike)Items.f_42690_);
        } else {
            return copyResult ? stack.m_41777_() : stack;
        }
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null) {
            newStack.m_41751_(compoundtag.m_6426_());
        }
        return newStack;
    }

    public static MutableComponent getPlainEnchantmentName(Enchantment enchantment, int level) {
        MutableComponent mutablecomponent = Component.m_237115_((String)enchantment.m_44704_());
        if (level != -1 && (level != 1 || EnchantingInfuserAPI.getEnchantStatsProvider().getMaxLevel(enchantment) != 1)) {
            mutablecomponent.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + level)));
        }
        return mutablecomponent;
    }
}

