/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.menu;

import com.enderio.api.capability.CoordinateSelection;
import com.enderio.base.common.init.EIOItems;
import com.enderio.base.common.init.EIOMenus;
import com.enderio.base.common.item.misc.LocationPrintoutItem;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class CoordinateMenu
extends AbstractContainerMenu {
    private final CoordinateSelection selection;
    private final boolean isPrintout;
    private String name;

    protected CoordinateMenu(@Nullable MenuType<CoordinateMenu> pMenuType, int pContainerId, FriendlyByteBuf buf) {
        super(pMenuType, pContainerId);
        this.selection = new CoordinateSelection(buf.m_130281_(), buf.m_130135_());
        this.isPrintout = buf.readBoolean();
        this.name = buf.m_130136_(50);
    }

    public CoordinateMenu(int containerID, CoordinateSelection selection, @Nullable String name) {
        super((MenuType)EIOMenus.COORDINATE.get(), containerID);
        this.selection = selection;
        this.isPrintout = name != null;
        this.name = name != null ? name : "";
    }

    public static CoordinateMenu factory(@Nullable MenuType<CoordinateMenu> pMenuType, int pContainerId, Inventory inventory, FriendlyByteBuf buf) {
        return new CoordinateMenu(pMenuType, pContainerId, buf);
    }

    public static FriendlyByteBuf writeAdditionalData(FriendlyByteBuf buf, CoordinateSelection selection, @Nullable String name) {
        buf.m_130085_(selection.level());
        buf.m_130064_(selection.pos());
        buf.writeBoolean(name == null);
        buf.m_130072_(name == null ? "" : name, 50);
        return buf;
    }

    public boolean m_6875_(Player pPlayer) {
        return CoordinateMenu.findInHand(pPlayer, this.isPrintout ? (Item)EIOItems.LOCATION_PRINTOUT.get() : (Item)EIOItems.COORDINATE_SELECTOR.get());
    }

    private static boolean findInHand(Player pPlayer, Item toFind) {
        return pPlayer.m_21205_().m_41720_() == toFind || pPlayer.m_21206_().m_41720_() == toFind;
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return ItemStack.f_41583_;
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        Optional<ItemStack> paper = CoordinateMenu.findPaper(pPlayer);
        if (paper.isPresent() && !this.isPrintout && pPlayer instanceof ServerPlayer) {
            ServerPlayer severPlayer = (ServerPlayer)pPlayer;
            paper.get().m_41774_(1);
            ItemStack itemstack = ((LocationPrintoutItem)EIOItems.LOCATION_PRINTOUT.get()).m_7968_();
            LocationPrintoutItem.setSelection(itemstack, this.selection);
            if (!StringUtils.isBlank((CharSequence)this.name)) {
                itemstack.m_41714_((Component)Component.m_237113_((String)this.name).m_130940_(ChatFormatting.AQUA));
            }
            if (severPlayer.m_6084_() && !severPlayer.m_9232_()) {
                severPlayer.m_150109_().m_150079_(itemstack);
            } else {
                severPlayer.m_36176_(itemstack, false);
            }
        }
    }

    private static Optional<ItemStack> findPaper(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != Items.f_42516_) continue;
            return Optional.of(stack);
        }
        for (ItemStack stack : player.m_150109_().f_35976_) {
            if (stack.m_41720_() != Items.f_42516_) continue;
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public String getName() {
        return this.name;
    }

    public void updateName(String name, ServerPlayer player) {
        this.setName(name);
        if (this.isPrintout) {
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = player.m_21120_(hand);
                if (stack.m_41720_() != EIOItems.LOCATION_PRINTOUT.get()) continue;
                if (StringUtils.isBlank((CharSequence)name)) {
                    stack.m_41787_();
                    continue;
                }
                stack.m_41714_((Component)Component.m_237113_((String)name).m_130940_(ChatFormatting.AQUA));
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public CoordinateSelection getSelection() {
        return this.selection;
    }
}

