/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network.slot;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public abstract class NetworkDataSlot<T> {
    protected Supplier<T> getter;
    private Consumer<T> setter;
    private int cachedHash;

    public NetworkDataSlot(Supplier<T> getter, Consumer<T> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Nullable
    public final Tag serializeNBT(boolean fullUpdate) {
        T value = this.getter.get();
        int hash = this.hashCode(value);
        if (!fullUpdate && this.cachedHash == hash) {
            return null;
        }
        this.cachedHash = hash;
        return this.serializeValueNBT(value);
    }

    public final void writeBuffer(FriendlyByteBuf buf) {
        T value = this.getter.get();
        this.cachedHash = this.hashCode(value);
        this.toBuffer(buf, value);
    }

    public void fromNBT(Tag nbt) {
        this.setter.accept(this.valueFromNBT(nbt));
    }

    public void fromBuffer(FriendlyByteBuf buf) {
        this.setter.accept(this.valueFromBuffer(buf));
    }

    public abstract Tag serializeValueNBT(T var1);

    protected abstract T valueFromNBT(Tag var1);

    public abstract void toBuffer(FriendlyByteBuf var1, T var2);

    protected abstract T valueFromBuffer(FriendlyByteBuf var1);

    public boolean needsUpdate() {
        T value = this.getter.get();
        int hash = this.hashCode(value);
        return this.cachedHash != hash;
    }

    protected int hashCode(T value) {
        return value.hashCode();
    }

    public void updateServerCallback() {
    }
}

