/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record CountedIngredient(Ingredient ingredient, int count) implements Predicate<ItemStack>
{
    public static final CountedIngredient EMPTY = new CountedIngredient(Ingredient.f_43901_, 0);

    public static CountedIngredient of() {
        return EMPTY;
    }

    public static CountedIngredient of(ItemLike ... items) {
        return CountedIngredient.of(Arrays.stream(items).map(ItemStack::new));
    }

    public static CountedIngredient of(int count, ItemLike ... items) {
        return CountedIngredient.of(count, Arrays.stream(items).map(ItemStack::new));
    }

    public static CountedIngredient of(ItemStack ... stacks) {
        return CountedIngredient.of(Arrays.stream(stacks));
    }

    public static CountedIngredient of(int count, ItemStack ... stacks) {
        return CountedIngredient.of(count, Arrays.stream(stacks));
    }

    public static CountedIngredient of(Stream<ItemStack> stacks) {
        return CountedIngredient.of(1, stacks);
    }

    public static CountedIngredient of(int count, Stream<ItemStack> stacks) {
        return new CountedIngredient(Ingredient.m_43921_(stacks), count);
    }

    public static CountedIngredient of(TagKey<Item> tag) {
        return CountedIngredient.of(1, tag);
    }

    public static CountedIngredient of(int count, TagKey<Item> tag) {
        return new CountedIngredient(Ingredient.m_43938_(Stream.of(new Ingredient.TagValue(tag))), count);
    }

    public static CountedIngredient of(Ingredient ingredient) {
        return new CountedIngredient(ingredient, 1);
    }

    public static CountedIngredient of(int count, Ingredient ingredient) {
        return new CountedIngredient(ingredient, count);
    }

    public List<ItemStack> getItems() {
        ItemStack[] matchingStacks;
        for (ItemStack matchingStack : matchingStacks = this.ingredient.m_43908_()) {
            matchingStack.m_41764_(this.count);
        }
        return List.of(matchingStacks);
    }

    @Override
    public boolean test(@Nullable ItemStack itemStack) {
        return this.ingredient.test(itemStack) && itemStack.m_41613_() >= this.count;
    }

    public static CountedIngredient fromJson(JsonObject json) {
        return new CountedIngredient(Ingredient.m_43917_((JsonElement)json.get("ingredient")), json.get("count").getAsInt());
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.add("ingredient", this.ingredient.m_43942_());
        json.addProperty("count", (Number)this.count);
        return json;
    }

    public static CountedIngredient fromNetwork(FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        return new CountedIngredient(ingredient, buffer.readShort());
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.writeShort(this.count());
    }
}

