/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerMutable;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.evilcraft.block.BlockDarkTankConfig;
import org.cyclops.evilcraft.core.block.IBlockTank;
import org.cyclops.evilcraft.core.helper.BlockTankHelpers;
import org.cyclops.evilcraft.core.helper.ItemHelpers;

public class ItemBlockFluidContainer
extends ItemBlockNBT {
    private IBlockTank block;

    public ItemBlockFluidContainer(Block block, Item.Properties builder) {
        super(block, builder);
        this.block = (IBlockTank)block;
    }

    public boolean m_5812_(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    protected boolean itemStackDataToTile(ItemStack itemStack, BlockEntity tile) {
        tile.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(fluidHandlerTile -> itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandlerItem -> {
            if (fluidHandlerTile instanceof IFluidHandlerMutable) {
                ((IFluidHandlerMutable)fluidHandlerTile).setFluidInTank(0, fluidHandlerItem.getFluidInTank(0));
            }
            if (fluidHandlerTile instanceof IFluidHandlerCapacity) {
                ((IFluidHandlerCapacity)fluidHandlerTile).setTankCapacity(0, fluidHandlerItem.getTankCapacity(0));
            }
        }));
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (this.block.isActivatable()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)this.block.toggleActivation(player.m_21120_(hand), world, player));
        }
        return super.m_7203_(world, player, hand);
    }

    protected void autofill(int itemSlot, IFluidHandlerItem source, Level world, Entity entity) {
        ItemHelpers.updateAutoFill(source, world, entity, BlockDarkTankConfig.autoFillBuckets);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.block.isActivatable() && this.block.isActivated(stack, worldIn)) {
            FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(fluidHandler -> this.autofill(itemSlot, (IFluidHandlerItem)fluidHandler, worldIn, entityIn));
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        if (ForgeCapabilities.FLUID_HANDLER != null) {
            list.add((Component)BlockTankHelpers.getInfoTank(itemStack));
        }
        if (this.block.isActivatable()) {
            L10NHelpers.addStatusInfo(list, (boolean)this.block.isActivated(itemStack, world), (String)(this.m_5524_() + ".info.auto_supply"));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_() || slotChanged;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new FluidHandlerItemCapacity(stack, this.block.getDefaultCapacity());
    }
}

