/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.Iterator;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.item.ItemInvigoratingPendantConfig;

public class ItemInvigoratingPendant
extends ItemBloodContainer {
    private static final int TICK_MODULUS = 10;

    public ItemInvigoratingPendant(Item.Properties properties) {
        super(properties, ItemInvigoratingPendantConfig.capacity);
    }

    public void clearBadEffects(ItemStack itemStack, Player player) {
        int amount = ItemInvigoratingPendantConfig.usage;
        if (this.canConsume(amount, itemStack, player)) {
            int originalReducableDuration;
            int reducableDuration = originalReducableDuration = ItemInvigoratingPendantConfig.reduceDuration * 20;
            Iterator it = Lists.newLinkedList((Iterable)player.m_21220_()).iterator();
            while (reducableDuration > 0 && it.hasNext() && this.canConsume(amount, itemStack, player)) {
                MobEffectInstance effect = (MobEffectInstance)it.next();
                MobEffect potion = effect.m_19544_();
                boolean shouldClear = true;
                if (potion != null) {
                    shouldClear = potion.m_19483_() == MobEffectCategory.HARMFUL;
                }
                if (!(shouldClear &= !effect.m_19571_())) continue;
                int reductionMultiplier = Math.max(1, effect.m_19564_() + 1);
                int reducableDurationForThisEffect = reducableDuration / reductionMultiplier;
                int remaining = effect.m_19557_();
                int toReduce = Math.min(reducableDurationForThisEffect, remaining);
                int toDrain = amount;
                reducableDuration -= toReduce;
                if (remaining == toReduce) {
                    player.m_21195_(potion);
                } else {
                    effect.f_19503_ = remaining - toReduce;
                    player.m_141973_(effect, true, null);
                    toDrain = (int)Math.ceil((double)(reductionMultiplier * amount) * ((double)toReduce / (double)originalReducableDuration));
                }
                this.consume(toDrain, itemStack, player);
            }
        }
        if (ItemInvigoratingPendantConfig.fireUsage >= 0 && player.m_6060_() && this.canConsume(ItemInvigoratingPendantConfig.fireUsage, itemStack, player)) {
            player.m_20095_();
            this.consume(ItemInvigoratingPendantConfig.fireUsage, itemStack, player);
        }
    }

    public void m_6883_(ItemStack itemStack, Level world, Entity entity, int par4, boolean par5) {
        if (entity instanceof Player && WorldHelpers.efficientTick((Level)world, (int)10, (int[])new int[]{entity.m_19879_()})) {
            this.clearBadEffects(itemStack, (Player)entity);
        }
        super.m_6883_(itemStack, world, entity, par4, par5);
    }
}

