/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.container;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.util.ConfigInventory;
import com.glodblock.github.extendedae.api.StorageMode;
import com.glodblock.github.extendedae.common.parts.PartPreciseStorageBus;
import com.glodblock.github.extendedae.network.EPPNetworkHandler;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.SGenericPacket;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import com.glodblock.github.glodium.network.packet.sync.Paras;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerPreciseStorageBus
extends UpgradeableMenu<PartPreciseStorageBus>
implements IActionHolder {
    private static final String ACTION_CLEAR = "clear";
    private static final String ACTION_PARTITION = "partition";
    private final Map<String, Consumer<Paras>> actions = this.createHolder();
    public static final MenuType<ContainerPreciseStorageBus> TYPE = MenuTypeBuilder.create(ContainerPreciseStorageBus::new, PartPreciseStorageBus.class).build("precise_storage_bus");
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;
    @GuiSync(value=7)
    public YesNo filterOnExtract = YesNo.YES;
    @GuiSync(value=8)
    @Nullable
    public Component connectedTo;
    @GuiSync(value=9)
    public StorageMode storageMode = StorageMode.DEFAULT;

    public ContainerPreciseStorageBus(int id, Inventory ip, PartPreciseStorageBus te) {
        super(TYPE, id, ip, (IUpgradeableObject)te);
        this.registerClientAction(ACTION_CLEAR, this::clear);
        this.registerClientAction(ACTION_PARTITION, this::partition);
        this.connectedTo = te.getConnectedToDescription();
        this.actions.put("set", o -> this.setMode((Integer)o.get(0)));
        this.actions.put("update", o -> {
            Player patt2782$temp = this.getPlayer();
            if (patt2782$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt2782$temp;
                EPPNetworkHandler.INSTANCE.sendTo((IMessage)new SGenericPacket("init", new Object[]{this.storageMode.ordinal()}), sp);
            }
        });
    }

    protected void setupConfig() {
        this.addExpandableConfigSlots((GenericStackInv)((PartPreciseStorageBus)this.getHost()).getConfig(), 2, 9, 5);
    }

    public void m_38946_() {
        super.m_38946_();
        this.connectedTo = ((PartPreciseStorageBus)this.getHost()).getConnectedToDescription();
        if (this.storageMode != ((PartPreciseStorageBus)this.getHost()).getStorageMode()) {
            this.storageMode = ((PartPreciseStorageBus)this.getHost()).getStorageMode();
        }
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setReadWriteMode((AccessRestriction)cm.getSetting(Settings.ACCESS));
        this.setStorageFilter((StorageFilter)cm.getSetting(Settings.STORAGE_FILTER));
        this.setFilterOnExtract((YesNo)cm.getSetting(Settings.FILTER_ON_EXTRACT));
    }

    public boolean isSlotEnabled(int idx) {
        int upgrades = this.getUpgrades().getInstalledUpgrades((ItemLike)AEItems.CAPACITY_CARD);
        return upgrades > idx;
    }

    public void clear() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_CLEAR);
            return;
        }
        ((PartPreciseStorageBus)this.getHost()).getConfig().clear();
        this.m_38946_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partition() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_PARTITION);
            return;
        }
        ConfigInventory inv = ((PartPreciseStorageBus)this.getHost()).getConfig();
        MEStorage cellInv = ((PartPreciseStorageBus)this.getHost()).getInternalHandler();
        Iterator i = Collections.emptyIterator();
        if (cellInv != null) {
            i = Iterators.transform((Iterator)cellInv.getAvailableStacks().iterator(), e -> new GenericStack((AEKey)e.getKey(), e.getLongValue()));
        }
        inv.beginBatch();
        try {
            for (int x = 0; x < inv.size(); ++x) {
                if (i.hasNext() && this.isSlotEnabled(x / 9 - 2)) {
                    inv.setStack(x, (GenericStack)i.next());
                    continue;
                }
                inv.setStack(x, null);
            }
        }
        finally {
            inv.endBatch();
        }
        this.m_38946_();
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }

    public YesNo getFilterOnExtract() {
        return this.filterOnExtract;
    }

    public void setFilterOnExtract(YesNo filterOnExtract) {
        this.filterOnExtract = filterOnExtract;
    }

    @Nullable
    public Component getConnectedTo() {
        return this.connectedTo;
    }

    public boolean isConfigSlot(Slot slot) {
        return this.getSlots(SlotSemantics.CONFIG).contains(slot);
    }

    public StorageMode getMode() {
        return this.storageMode;
    }

    public void setMode(int mode) {
        ((PartPreciseStorageBus)this.getHost()).setStorageMode(StorageMode.values()[mode]);
        this.m_38946_();
    }

    @NotNull
    public Map<String, Consumer<Paras>> getActionMap() {
        return this.actions;
    }
}

