/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.singularity;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;

public class Singularity {
    private final ResourceLocation id;
    private final String name;
    private final int[] colors;
    private final String tag;
    private final int ingredientCount;
    private final boolean inUltimateSingularity;
    private Ingredient ingredient;
    private boolean enabled = true;

    public Singularity(ResourceLocation id, String name, int[] colors, Ingredient ingredient, int ingredientCount, boolean inUltimateSingularity) {
        this.id = id;
        this.name = name;
        this.colors = colors;
        this.ingredient = ingredient;
        this.tag = null;
        this.ingredientCount = ingredientCount;
        this.inUltimateSingularity = inUltimateSingularity;
    }

    public Singularity(ResourceLocation id, String name, int[] colors, Ingredient ingredient) {
        this(id, name, colors, ingredient, -1, true);
    }

    public Singularity(ResourceLocation id, String name, int[] colors, String tag, int ingredientCount, boolean inUltimateSingularity) {
        this.id = id;
        this.name = name;
        this.colors = colors;
        this.ingredient = Ingredient.f_43901_;
        this.tag = tag;
        this.ingredientCount = ingredientCount;
        this.inUltimateSingularity = inUltimateSingularity;
    }

    public Singularity(ResourceLocation id, String name, int[] colors, String tag) {
        this(id, name, colors, tag, -1, true);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getOverlayColor() {
        return this.colors[0];
    }

    public int getUnderlayColor() {
        return this.colors[1];
    }

    public String getTag() {
        return this.tag;
    }

    public Ingredient getIngredient() {
        if (this.tag != null && this.ingredient == Ingredient.f_43901_) {
            TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation(this.tag));
            this.ingredient = Ingredient.m_204132_((TagKey)tag);
        }
        return this.ingredient;
    }

    public int getIngredientCount() {
        if (this.ingredientCount == -1) {
            return (Integer)ModConfigs.SINGULARITY_MATERIALS_REQUIRED.get();
        }
        return this.ingredientCount;
    }

    public Component getDisplayName() {
        return Localizable.of((String)this.name).build();
    }

    public boolean isInUltimateSingularity() {
        return this.inUltimateSingularity;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        buffer.m_130070_(this.name);
        buffer.m_130089_(this.colors);
        buffer.writeBoolean(this.tag != null);
        if (this.tag != null) {
            buffer.m_130070_(this.tag);
        } else {
            this.ingredient.m_43923_(buffer);
        }
        buffer.m_130130_(this.getIngredientCount());
        buffer.writeBoolean(this.inUltimateSingularity);
        buffer.writeBoolean(this.enabled);
    }

    public static Singularity read(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        String name = buffer.m_130277_();
        int[] colors = buffer.m_130100_();
        boolean isTagIngredient = buffer.readBoolean();
        String tag = null;
        Ingredient ingredient = Ingredient.f_43901_;
        if (isTagIngredient) {
            tag = buffer.m_130277_();
        } else {
            ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        }
        int ingredientCount = buffer.m_130242_();
        boolean isInUltimateSingularity = buffer.readBoolean();
        Singularity singularity = isTagIngredient ? new Singularity(id, name, colors, tag, ingredientCount, isInUltimateSingularity) : new Singularity(id, name, colors, ingredient, ingredientCount, isInUltimateSingularity);
        singularity.enabled = buffer.readBoolean();
        return singularity;
    }
}

