/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import net.minecraft.world.item.ItemStack;
import xfacthd.framedblocks.common.compat.emi.EmiCompat;
import xfacthd.framedblocks.common.compat.jei.JeiCompat;
import xfacthd.framedblocks.common.compat.rei.ReiCompat;

public enum RecipeViewer {
    JEI(JeiCompat::isShowRecipePressed, JeiCompat::handleShowRecipeRequest),
    REI(ReiCompat::isShowRecipePressed, ReiCompat::handleShowRecipeRequest),
    EMI((keyCode, scanCode) -> null, (stack, target) -> false);

    private final ShowRecipeKeyTest showKeyTest;
    private final RecipeShower recipeShower;

    private RecipeViewer(ShowRecipeKeyTest showKeyTest, RecipeShower recipeShower) {
        this.showKeyTest = showKeyTest;
        this.recipeShower = recipeShower;
    }

    public LookupTarget isShowRecipePressed(int keyCode, int scanCode) {
        return this.showKeyTest.isShowRecipePressed(keyCode, scanCode);
    }

    public boolean handleShowRecipeRequest(ItemStack stack, LookupTarget target) {
        return this.recipeShower.handleShowRecipeRequest(stack, target);
    }

    public static RecipeViewer get() {
        if (EmiCompat.isLoaded()) {
            return EMI;
        }
        if (JeiCompat.isLoaded()) {
            return JEI;
        }
        if (ReiCompat.isLoaded()) {
            return REI;
        }
        return null;
    }

    private static interface ShowRecipeKeyTest {
        public LookupTarget isShowRecipePressed(int var1, int var2);
    }

    private static interface RecipeShower {
        public boolean handleShowRecipeRequest(ItemStack var1, LookupTarget var2);
    }

    public static enum LookupTarget {
        RECIPE,
        USAGE;

    }
}

