/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.js;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import org.openjdk.nashorn.api.scripting.ScriptUtils;
import org.zeith.hammerlib.util.shaded.json.JSONArray;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

public class ObjectMirrorConverter {
    public static <T> T unwrap(Object input, Class<T> returnType) {
        Object uw = ScriptUtils.unwrap((Object)input);
        if (returnType.isInstance(uw)) {
            return (T)uw;
        }
        if (input instanceof ScriptObjectMirror) {
            ScriptObjectMirror som = (ScriptObjectMirror)input;
            return (T)som.to(returnType);
        }
        return null;
    }

    public static JsonElement toGson(ScriptObjectMirror mirror) {
        if (mirror.isArray()) {
            JsonArray a = new JsonArray();
            int s = mirror.size();
            for (int i = 0; i < s; ++i) {
                a.add(ObjectMirrorConverter.toGson(mirror.getSlot(i)));
            }
            return a;
        }
        JsonObject o = new JsonObject();
        for (String key : mirror.getOwnKeys(true)) {
            o.add(key, ObjectMirrorConverter.toGson(mirror.get((Object)key)));
        }
        return o;
    }

    private static JsonElement toGson(Object o) {
        if (o == null) {
            return JsonNull.INSTANCE;
        }
        if (o instanceof ScriptObjectMirror) {
            ScriptObjectMirror som = (ScriptObjectMirror)o;
            return ObjectMirrorConverter.toGson(som);
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return new JsonPrimitive(b);
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return new JsonPrimitive(n);
        }
        if (o instanceof String) {
            String s = (String)o;
            return new JsonPrimitive(s);
        }
        if (o instanceof Character) {
            Character c = (Character)o;
            return new JsonPrimitive(c);
        }
        return JsonNull.INSTANCE;
    }

    public static Object toJson(ScriptObjectMirror mirror) {
        if (mirror.isArray()) {
            JSONArray a = new JSONArray();
            int s = mirror.size();
            for (int i = 0; i < s; ++i) {
                a.put(ObjectMirrorConverter.toJson(mirror.getSlot(i)));
            }
            return a;
        }
        JSONObject o = new JSONObject();
        for (String key : mirror.getOwnKeys(true)) {
            o.put(key, ObjectMirrorConverter.toJson(mirror.get((Object)key)));
        }
        return o;
    }

    private static Object toJson(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof ScriptObjectMirror) {
            ScriptObjectMirror som = (ScriptObjectMirror)o;
            return ObjectMirrorConverter.toJson(som);
        }
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            return b;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return n;
        }
        if (o instanceof String) {
            String s = (String)o;
            return s;
        }
        if (o instanceof Character) {
            Character c = (Character)o;
            return c;
        }
        return null;
    }
}

