/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.fml;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.niofs.union.UnionFileSystem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;

public class FMLFingerprintCheckEvent
extends ModLifecycleEvent {
    private final Optional<String> gotFingerprint;
    private final Optional<String> trustData;
    protected final FMLModContainer ctr;
    protected final java.util.function.Supplier<Set<String>> filesViolated;
    protected java.util.function.Supplier<Boolean> anyFilesViolated;
    protected String expectedSignature;

    public FMLFingerprintCheckEvent(FMLModContainer container) {
        super((ModContainer)container);
        this.ctr = container;
        SecureJar jar = container.getModInfo().getOwningFile().getFile().getSecureJar();
        Path root = ((UnionFileSystem)jar.getRootPath().getFileSystem()).getRoot();
        SecureJar.ModuleDataProvider mdp = jar.moduleDataProvider();
        Manifest mf = mdp.getManifest();
        Supplier entries = Suppliers.memoize(() -> mf.getEntries().entrySet().stream().filter(e -> ((Attributes)e.getValue()).keySet().stream().anyMatch(str -> Objects.toString(str).contains("Digest"))).map(Map.Entry::getKey).toList());
        this.anyFilesViolated = Suppliers.memoize(() -> FMLFingerprintCheckEvent.lambda$new$6(root, (java.util.function.Supplier)entries, jar));
        this.filesViolated = Suppliers.memoize(() -> FMLFingerprintCheckEvent.lambda$new$10(root, (java.util.function.Supplier)entries, jar));
        ModFileInfo mfi = (ModFileInfo)container.getModInfo().getOwningFile();
        this.gotFingerprint = mfi.getCodeSigningFingerprint();
        Optional trustData = Optional.empty();
        try {
            trustData = mfi.getTrustData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.trustData = trustData;
    }

    private void expectSigned(String signature) {
        this.expectedSignature = signature;
    }

    public boolean isJarSigned() {
        return this.trustData.isPresent() || this.gotFingerprint.isPresent();
    }

    public FMLModContainer getModContainer() {
        return this.ctr;
    }

    public Optional<String> fingerprint() {
        return this.gotFingerprint;
    }

    public Optional<String> trustData() {
        return this.trustData;
    }

    public Set<String> getInvalidSignedFiles() {
        return this.filesViolated.get();
    }

    public boolean anyInvalidFiles() {
        return this.anyFilesViolated.get();
    }

    public boolean isViolated(String expectFingerprint) {
        this.expectSigned(this.expectedSignature);
        expectFingerprint = expectFingerprint.replace(":", "").toLowerCase(Locale.ROOT);
        String gotFingerprint = this.fingerprint().map(f -> f.replace(":", "").toLowerCase(Locale.ROOT)).orElse(null);
        return !Objects.equals(gotFingerprint, expectFingerprint) || !this.getInvalidSignedFiles().isEmpty();
    }

    @Generated
    public String getExpectedSignature() {
        return this.expectedSignature;
    }

    private static /* synthetic */ Set lambda$new$10(Path root, java.util.function.Supplier entries, SecureJar jar) {
        Set set;
        block9: {
            if (!FMLEnvironment.production) {
                return Collections.emptySet();
            }
            Stream<Path> walk = Files.walk(root, new FileVisitOption[0]);
            try {
                HashSet allEntries = new HashSet((Collection)entries.get());
                HashSet violated = new HashSet(walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).peek(pth -> allEntries.remove(pth.toString())).filter(e -> jar.verifyPath(e) == SecureJar.Status.INVALID).map(root::relativize).map(Path::toString).collect(Collectors.toSet()));
                violated.addAll(allEntries);
                set = Set.copyOf(violated);
                if (walk == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }
            walk.close();
        }
        return set;
    }

    private static /* synthetic */ Boolean lambda$new$6(Path root, java.util.function.Supplier entries, SecureJar jar) {
        Boolean bl;
        block9: {
            if (!FMLEnvironment.production) {
                return false;
            }
            Stream<Path> walk = Files.walk(root, new FileVisitOption[0]);
            try {
                HashSet allEntries = new HashSet((Collection)entries.get());
                boolean violated = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).peek(pth -> allEntries.remove(pth.toString())).anyMatch(e -> jar.verifyPath(e) == SecureJar.Status.INVALID);
                bl = violated || !allEntries.isEmpty();
                if (walk == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }
            walk.close();
        }
        return bl;
    }
}

