/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;

@MainThreaded
public class SyncTileEntityPacket
implements IPacket {
    BlockPos pos;
    CompoundTag nbt;
    boolean updateTag;

    public SyncTileEntityPacket() {
    }

    public SyncTileEntityPacket(BlockEntity tile, boolean updateTag) {
        this.pos = tile.m_58899_();
        this.nbt = updateTag ? tile.m_5995_() : tile.serializeNBT();
        this.updateTag = updateTag;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130079_(this.nbt);
        buf.writeBoolean(this.updateTag);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.nbt = buf.m_130260_();
        this.updateTag = buf.readBoolean();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        Level world = ((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).orElse(null);
        if (world == null) {
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile != null) {
            if (this.updateTag) {
                tile.handleUpdateTag(this.nbt);
            } else {
                tile.m_142466_(this.nbt);
            }
        }
    }
}

