/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.zeith.hammerlib.util.configured.ConfigFile;
import org.zeith.hammerlib.util.configured.ConfigToken;
import org.zeith.hammerlib.util.configured.io.buf.IByteBuf;
import org.zeith.hammerlib.util.configured.types.ConfigArray;
import org.zeith.hammerlib.util.configured.types.ConfigBoolean;
import org.zeith.hammerlib.util.configured.types.ConfigCategory;
import org.zeith.hammerlib.util.configured.types.ConfigDecimal;
import org.zeith.hammerlib.util.configured.types.ConfigElement;
import org.zeith.hammerlib.util.configured.types.ConfigInteger;
import org.zeith.hammerlib.util.configured.types.ConfigString;

public class ConfiguredLib {
    public static final String VERSION = "1.0.0";
    static final Map<String, ConfigToken<?>> TOKEN_REGISTRY_BY_PREFIX = new HashMap();
    public static final ConfigToken<ConfigCategory> CATEGORY = new ConfigToken<ConfigCategory>("C", ConfigCategory.class, ConfigCategory::new);
    public static final ConfigToken<ConfigBoolean> BOOLEAN = new ConfigToken<ConfigBoolean>("B", ConfigBoolean.class, ConfigBoolean::new);
    public static final ConfigToken<ConfigString> STRING = new ConfigToken<ConfigString>("S", ConfigString.class, ConfigString::new);
    public static final ConfigToken<ConfigInteger> INT = new ConfigToken<ConfigInteger>("I", ConfigInteger.class, ConfigInteger::new);
    public static final ConfigToken<ConfigDecimal> DECIMAL = new ConfigToken<ConfigDecimal>("D", ConfigDecimal.class, ConfigDecimal::new);

    public static ConfigToken<?> getByPrefix(String prefix) {
        if ((prefix = prefix.toLowerCase(Locale.ROOT)).startsWith("[")) {
            ConfigToken<?> cToken = ConfiguredLib.getByPrefix(prefix.substring(1));
            TOKEN_REGISTRY_BY_PREFIX.put("[" + cToken.getPrefix(), new ConfigToken<ConfigElement>(prefix, ConfigArray.class, (onChanged, token, name) -> new ConfigArray(onChanged, token, cToken, name)));
        }
        return TOKEN_REGISTRY_BY_PREFIX.get(prefix);
    }

    public static ConfigFile create(File file, boolean load) {
        ConfigFile cfg = new ConfigFile(file);
        if (load) {
            cfg.load();
        }
        return cfg;
    }

    public static ConfigFile createInMemory(IByteBuf buf) {
        return new ConfigFile(buf);
    }
}

