/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.komaruholograms.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import ru.auriny.komaruholograms.KomaruHolograms;
import ru.auriny.komaruholograms.data.HologramData;
import ru.auriny.komaruholograms.data.HologramSaveData;
import ru.auriny.komaruholograms.util.HologramManager;

public class HoloCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"holo").requires(p -> p.m_6761_(2))).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            String text = StringArgumentType.getString((CommandContext)ctx, (String)"text");
            KomaruHolograms.LOGGER.debug("Creating hologram id:{} text:{}", (Object)id, (Object)text);
            ServerLevel level = source.m_81372_();
            Vec3 vec = source.m_81371_();
            Display.TextDisplay display = new Display.TextDisplay(EntityType.f_268607_, (Level)level);
            display.m_146884_(vec);
            display.m_269037_((Component)Component.m_237113_((String)""));
            display.m_20049_("holo:" + id);
            level.m_7967_((Entity)display);
            display.m_20088_().m_135381_(Display.f_268593_, (Object)3);
            HologramManager.register(id, display);
            HologramData holoData = new HologramData(vec, text, 1.0f, 0.0f, 0.0f, Display.BillboardConstraints.CENTER, Display.TextDisplay.Align.CENTER, 200);
            HologramSaveData.get(level).add(id, holoData);
            HologramManager.update(id);
            source.m_288197_(() -> Component.m_237113_((String)"\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430"), false);
            return 1;
        }))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            KomaruHolograms.LOGGER.info("Deleting hologram {}", (Object)id);
            Display.TextDisplay display = HologramManager.get(id);
            if (display != null) {
                display.m_6074_();
            }
            HologramManager.unregister(id);
            ServerLevel level = source.m_81372_();
            HologramSaveData saveData = HologramSaveData.get(level);
            saveData.remove(id);
            source.m_288197_(() -> Component.m_237113_((String)"\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0430"), false);
            return 1;
        })))).then(Commands.m_82127_((String)"nearest").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerLevel level = source.m_81372_();
            Vec3 sourcePos = source.m_81371_();
            double closestDistance = Double.MAX_VALUE;
            String closestId = null;
            for (Entity entity : level.m_45933_(null, new AABB(sourcePos, sourcePos).m_82400_(64.0))) {
                if (!(entity instanceof Display.TextDisplay)) continue;
                Display.TextDisplay display = (Display.TextDisplay)entity;
                for (String tag : display.m_19880_()) {
                    double distance;
                    if (!tag.startsWith("holo:") || !((distance = entity.m_20238_(sourcePos)) < closestDistance)) continue;
                    closestDistance = distance;
                    closestId = tag.substring("holo:".length());
                }
            }
            if (closestId != null) {
                String finalClosestId = closestId;
                source.m_288197_(() -> Component.m_237113_((String)("\u0411\u043b\u0438\u0436\u0430\u0439\u0448\u0430\u044f \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430: " + finalClosestId)), false);
            } else {
                source.m_81352_((Component)Component.m_237113_((String)"\u0412 \u0440\u0430\u0434\u0438\u0443\u0441\u0435 64 \u0431\u043b\u043e\u043a\u043e\u0432 \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c \u043d\u0435\u0442."));
            }
            return 1;
        }))).then(Commands.m_82127_((String)"scale").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"scale", (ArgumentType)FloatArgumentType.floatArg((float)0.01f, (float)100.0f)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerLevel level = source.m_81372_();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            float scale = FloatArgumentType.getFloat((CommandContext)ctx, (String)"scale");
            Display.TextDisplay display = HologramManager.get(id);
            if (display == null) {
                source.m_81352_((Component)Component.m_237113_((String)("\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0441 id '" + id + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")));
                return 0;
            }
            EntityDataAccessor scaleAccessor = Display.f_268489_;
            display.m_20088_().m_135381_(scaleAccessor, (Object)new Vector3f(scale, scale, scale));
            HologramSaveData saveData = HologramSaveData.get(level);
            HologramData data = saveData.getAll().get(id);
            if (data != null) {
                HologramData holoData = new HologramData(data.vec(), data.text(), scale, data.yaw(), data.pitch(), data.billboard(), data.align(), data.width());
                saveData.add(id, holoData);
            }
            source.m_288197_(() -> Component.m_237113_((String)("\u0420\u0430\u0437\u043c\u0435\u0440 \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u044b '" + id + "' \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0432 " + scale)), false);
            return 1;
        }))))).then(Commands.m_82127_((String)"rotate").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"yaw", (ArgumentType)FloatArgumentType.floatArg((float)-180.0f, (float)180.0f)).then(Commands.m_82129_((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)-90.0f, (float)90.0f)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerLevel level = source.m_81372_();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            float yaw = FloatArgumentType.getFloat((CommandContext)ctx, (String)"yaw");
            float pitch = FloatArgumentType.getFloat((CommandContext)ctx, (String)"pitch");
            Display.TextDisplay display = HologramManager.get(id);
            if (display == null) {
                source.m_81352_((Component)Component.m_237113_((String)("\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0441 id '" + id + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")));
                return 0;
            }
            display.m_146922_(yaw);
            display.m_146926_(pitch);
            HologramSaveData saveData = HologramSaveData.get(level);
            HologramData data = saveData.getAll().get(id);
            if (data != null) {
                HologramData newData = new HologramData(data.vec(), data.text(), data.scale(), yaw, pitch, data.billboard(), data.align(), data.width());
                saveData.add(id, newData);
            }
            source.m_288197_(() -> Component.m_237113_((String)("\u041f\u043e\u0432\u043e\u0440\u043e\u0442 \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u044b '" + id + "' \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d: yaw=" + yaw + ", pitch=" + pitch)), false);
            return 1;
        })))))).then(Commands.m_82127_((String)"billboard").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Display.BillboardConstraints constraint;
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            String typeStr = StringArgumentType.getString((CommandContext)ctx, (String)"type").toUpperCase();
            Display.TextDisplay display = HologramManager.get(id);
            if (display == null) {
                source.m_81352_((Component)Component.m_237113_((String)("\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0441 id '" + id + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")));
                return 0;
            }
            try {
                constraint = Display.BillboardConstraints.valueOf((String)typeStr);
            }
            catch (IllegalArgumentException e) {
                source.m_81352_((Component)Component.m_237113_((String)("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f billboard: " + typeStr + ". \u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0442\u0438\u043f\u044b: FIXED, CENTER, HORIZONTAL, VERTICAL")));
                return 0;
            }
            display.m_20088_().m_135381_(Display.f_268593_, (Object)((byte)constraint.ordinal()));
            ServerLevel level = source.m_81372_();
            HologramSaveData saveData = HologramSaveData.get(level);
            HologramData data = saveData.getAll().get(id);
            if (data == null) {
                source.m_81352_((Component)Component.m_237113_((String)"\u0421\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b"));
                return 0;
            }
            HologramData updated = new HologramData(data.vec(), data.text(), data.scale(), data.yaw(), data.pitch(), constraint, data.align(), data.width());
            saveData.add(id, updated);
            source.m_288197_(() -> Component.m_237113_((String)("Billboard \u0434\u043b\u044f '" + id + "' \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0432 " + constraint.name())), false);
            return 1;
        }))))).then(Commands.m_82127_((String)"text").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            String newText = StringArgumentType.getString((CommandContext)ctx, (String)"text");
            Display.TextDisplay display = HologramManager.get(id);
            if (display == null) {
                source.m_81352_((Component)Component.m_237113_((String)("\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0441 id '" + id + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")));
                return 0;
            }
            display.m_269037_((Component)Component.m_237113_((String)newText));
            ServerLevel level = source.m_81372_();
            HologramSaveData saveData = HologramSaveData.get(level);
            HologramData data = saveData.getAll().get(id);
            if (data != null) {
                HologramData updated = new HologramData(data.vec(), newText, data.scale(), data.yaw(), data.pitch(), data.billboard(), data.align(), data.width());
                saveData.add(id, updated);
                source.m_288197_(() -> Component.m_237113_((String)("\u0422\u0435\u043a\u0441\u0442 \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u044b '" + id + "' \u0438\u0437\u043c\u0435\u043d\u0451\u043d \u043d\u0430: " + newText)), false);
            } else {
                source.m_81352_((Component)Component.m_237113_((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u0433\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u044b."));
            }
            return 1;
        }))))).then(Commands.m_82127_((String)"align").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            Display.TextDisplay.Align align;
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            String typeStr = StringArgumentType.getString((CommandContext)ctx, (String)"type").toUpperCase();
            Display.TextDisplay display = HologramManager.get(id);
            if (display == null) {
                source.m_81352_((Component)Component.m_237113_((String)("\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0441 id '" + id + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")));
                return 0;
            }
            try {
                align = Display.TextDisplay.Align.valueOf((String)typeStr);
            }
            catch (IllegalArgumentException e) {
                source.m_81352_((Component)Component.m_237113_((String)("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f align: " + typeStr + ". \u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0442\u0438\u043f\u044b: CENTER, RIGHT, LEFT")));
                return 0;
            }
            byte flags = display.m_269327_();
            flags = (byte)(flags & 0xFFFFFFE7);
            switch (align) {
                case LEFT: {
                    flags = (byte)(flags | 8);
                    break;
                }
                case RIGHT: {
                    flags = (byte)(flags | 0x10);
                    break;
                }
                case CENTER: {
                    flags = (byte)(flags | 0);
                }
            }
            display.m_269559_(flags);
            ServerLevel level = source.m_81372_();
            HologramSaveData saveData = HologramSaveData.get(level);
            HologramData data = saveData.getAll().get(id);
            if (data == null) {
                source.m_81352_((Component)Component.m_237113_((String)"\u0421\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b"));
                return 0;
            }
            HologramData updated = new HologramData(data.vec(), data.text(), data.scale(), data.yaw(), data.pitch(), data.billboard(), align, data.width());
            saveData.add(id, updated);
            source.m_288197_(() -> Component.m_237113_((String)("Billboard \u0434\u043b\u044f '" + id + "' \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0432 " + align.name())), false);
            return 1;
        }))))).then(Commands.m_82127_((String)"tphere").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            Display.TextDisplay display = HologramManager.get(id);
            if (display == null) {
                source.m_81352_((Component)Component.m_237113_((String)("\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0441 id '" + id + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")));
                return 0;
            }
            Vec3 pos = source.m_81371_();
            display.m_146884_(pos);
            ServerLevel level = source.m_81372_();
            HologramSaveData saveData = HologramSaveData.get(level);
            HologramData data = saveData.getAll().get(id);
            if (data != null) {
                HologramData updated = new HologramData(pos, data.text(), data.scale(), data.yaw(), data.pitch(), data.billboard(), data.align(), data.width());
                saveData.add(id, updated);
            }
            source.m_288197_(() -> Component.m_237113_((String)("\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 '" + id + "' \u0442\u0435\u043b\u0435\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0430")), false);
            return 1;
        })))).then(Commands.m_82127_((String)"pos").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"x", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.m_82129_((String)"y", (ArgumentType)FloatArgumentType.floatArg()).then(Commands.m_82129_((String)"z", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            float x = FloatArgumentType.getFloat((CommandContext)ctx, (String)"x");
            float y = FloatArgumentType.getFloat((CommandContext)ctx, (String)"y");
            float z = FloatArgumentType.getFloat((CommandContext)ctx, (String)"z");
            Display.TextDisplay display = HologramManager.get(id);
            if (display == null) {
                source.m_81352_((Component)Component.m_237113_((String)("\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0441 id '" + id + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")));
                return 0;
            }
            Vec3 newPos = new Vec3((double)x, (double)y, (double)z);
            display.m_146884_(newPos);
            ServerLevel level = source.m_81372_();
            HologramSaveData saveData = HologramSaveData.get(level);
            HologramData data = saveData.getAll().get(id);
            if (data != null) {
                HologramData updated = new HologramData(newPos, data.text(), data.scale(), data.yaw(), data.pitch(), data.billboard(), data.align(), data.width());
                saveData.add(id, updated);
            }
            source.m_288197_(() -> Component.m_237113_((String)("\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 '" + id + "' \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0430 \u043d\u0430 " + x + ", " + y + ", " + z)), false);
            return 1;
        }))))))).then(Commands.m_82127_((String)"width").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10000)).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            int width = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            Display.TextDisplay display = HologramManager.get(id);
            if (display == null) {
                source.m_81352_((Component)Component.m_237113_((String)("\u0413\u043e\u043b\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0441 id '" + id + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")));
                return 0;
            }
            display.m_269174_(width);
            ServerLevel level = source.m_81372_();
            HologramSaveData saveData = HologramSaveData.get(level);
            HologramData data = saveData.getAll().get(id);
            if (data == null) {
                source.m_81352_((Component)Component.m_237113_((String)"\u0421\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b"));
                return 0;
            }
            HologramData updated = new HologramData(data.vec(), data.text(), data.scale(), data.yaw(), data.pitch(), data.billboard(), data.align(), width);
            saveData.add(id, updated);
            source.m_288197_(() -> Component.m_237113_((String)("\u0428\u0438\u0440\u0438\u043d\u0430 \u0434\u043b\u044f '" + id + "' \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430: " + width)), false);
            return 1;
        })))));
    }
}

