/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.komaruholograms.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import ru.auriny.komaruholograms.KomaruHolograms;
import ru.auriny.komaruholograms.data.HologramData;

public class HologramSaveData
extends SavedData {
    private final Map<String, HologramData> holograms = new HashMap<String, HologramData>();

    public static HologramSaveData get(ServerLevel level) {
        return (HologramSaveData)level.m_8895_().m_164861_(HologramSaveData::fromNbt, HologramSaveData::new, "holograms");
    }

    public void add(String id, HologramData data) {
        this.holograms.put(id, data);
        this.m_77762_();
    }

    public Map<String, HologramData> getAll() {
        return this.holograms;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        ListTag list = new ListTag();
        for (Map.Entry<String, HologramData> entry : this.holograms.entrySet()) {
            CompoundTag holoTag = new CompoundTag();
            holoTag.m_128359_("id", entry.getKey());
            holoTag.m_128365_("data", (Tag)entry.getValue().toNbt());
            list.add((Object)holoTag);
        }
        tag.m_128365_("holograms", (Tag)list);
        return tag;
    }

    public static HologramSaveData fromNbt(CompoundTag tag) {
        HologramSaveData data = new HologramSaveData();
        ListTag list = tag.m_128437_("holograms", 10);
        KomaruHolograms.LOGGER.debug("NBT hologram list size: {}", (Object)list.size());
        for (Tag t : list) {
            CompoundTag holoTag = (CompoundTag)t;
            String id = holoTag.m_128461_("id");
            HologramData holoData = HologramData.fromNbt(holoTag.m_128469_("data"));
            KomaruHolograms.LOGGER.debug("Parsed hologram from NBT -> id: {}, text: {}", (Object)id, (Object)holoData.text());
            data.holograms.put(id, holoData);
        }
        data.m_77762_();
        return data;
    }

    public void remove(String id) {
        this.holograms.remove(id);
        this.m_77762_();
    }
}

