/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.komaruholograms.data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ru.auriny.komaruholograms.KomaruHolograms;
import ru.auriny.komaruholograms.data.HologramData;
import ru.auriny.komaruholograms.data.HologramSaveData;

public class PlaceholderStore {
    private static final Map<String, String> placeholders = new ConcurrentHashMap<String, String>();

    public static void set(String id, String text) {
        KomaruHolograms.LOGGER.debug("Setting placeholder {} -> {}", (Object)id, (Object)text);
        placeholders.put(id, text);
    }

    public static void remove(String id) {
        placeholders.remove(id);
    }

    public static String get(String id) {
        return placeholders.getOrDefault(id, "<...>");
    }

    public static void loadFromSave(HologramSaveData data) {
        KomaruHolograms.LOGGER.debug("Loading placeholders from HologramSaveData...");
        for (Map.Entry<String, HologramData> entry : data.getAll().entrySet()) {
            KomaruHolograms.LOGGER.debug("-> loading id: {}, text: {}", (Object)entry.getKey(), (Object)entry.getValue().text());
            placeholders.put(entry.getKey(), entry.getValue().text());
        }
    }
}

