/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.komaruholograms.event;

import java.time.LocalTime;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector3f;
import ru.auriny.komaruholograms.KomaruHolograms;
import ru.auriny.komaruholograms.data.HologramData;
import ru.auriny.komaruholograms.data.HologramSaveData;
import ru.auriny.komaruholograms.data.PlaceholderStore;
import ru.auriny.komaruholograms.util.HologramManager;

@Mod.EventBusSubscriber(modid="komaruholograms", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerEvents {
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter >= 100) {
            tickCounter = 0;
            HologramManager.updateAll();
            ServerEvents.updatePlaceholders(event.getServer());
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        KomaruHolograms.LOGGER.debug("Reviving holos");
        ServerEvents.updatePlaceholders(server);
        for (ServerLevel level : server.m_129785_()) {
            KomaruHolograms.LOGGER.debug("Loading from level: {}", (Object)level.m_46472_().m_135782_());
            HologramSaveData saveData = HologramSaveData.get(level);
            PlaceholderStore.loadFromSave(saveData);
            for (Map.Entry<String, HologramData> entry : saveData.getAll().entrySet()) {
                String id = entry.getKey();
                HologramData data = entry.getValue();
                Display.TextDisplay display = new Display.TextDisplay(EntityType.f_268607_, (Level)level);
                display.m_146884_(data.vec());
                display.m_146922_(data.yaw());
                display.m_146926_(data.pitch());
                display.m_269037_((Component)Component.m_237113_((String)""));
                display.m_20088_().m_135381_(Display.f_268489_, (Object)new Vector3f(data.scale(), data.scale(), data.scale()));
                display.m_20088_().m_135381_(Display.f_268593_, (Object)((byte)data.billboard().ordinal()));
                display.m_269174_(data.width());
                byte flags = display.m_269327_();
                flags = (byte)(flags & 0xFFFFFFE7);
                switch (data.align()) {
                    case LEFT: {
                        flags = (byte)(flags | 8);
                        break;
                    }
                    case RIGHT: {
                        flags = (byte)(flags | 0x10);
                        break;
                    }
                }
                display.m_269559_(flags);
                display.m_20049_("holo:" + id);
                level.m_7967_((Entity)display);
                HologramManager.register(id, display);
            }
        }
        HologramManager.updateAll();
    }

    private static void updatePlaceholders(MinecraftServer server) {
        KomaruHolograms.LOGGER.debug("Updating placeholders");
        PlaceholderStore.set("time", LocalTime.now().toString());
        PlaceholderStore.set("players", String.valueOf(server.m_7416_()));
        PlaceholderStore.set("nl", "\n");
        PlaceholderStore.set("black", "\u00a70");
        PlaceholderStore.set("dark_blue", "\u00a71");
        PlaceholderStore.set("dark_green", "\u00a72");
        PlaceholderStore.set("dark_aqua", "\u00a73");
        PlaceholderStore.set("dark_red", "\u00a74");
        PlaceholderStore.set("dark_purple", "\u00a75");
        PlaceholderStore.set("gold", "\u00a76");
        PlaceholderStore.set("gray", "\u00a77");
        PlaceholderStore.set("dark_gray", "\u00a78");
        PlaceholderStore.set("blue", "\u00a79");
        PlaceholderStore.set("green", "\u00a7a");
        PlaceholderStore.set("aqua", "\u00a7b");
        PlaceholderStore.set("red", "\u00a7c");
        PlaceholderStore.set("light_purple", "\u00a7d");
        PlaceholderStore.set("yellow", "\u00a7e");
        PlaceholderStore.set("white", "\u00a7f");
        PlaceholderStore.set("bold", "\u00a7l");
        PlaceholderStore.set("italic", "\u00a7o");
        PlaceholderStore.set("underlined", "\u00a7n");
        PlaceholderStore.set("strikethrough", "\u00a7m");
        PlaceholderStore.set("obfuscated", "\u00a7k");
        PlaceholderStore.set("reset", "\u00a7r");
    }
}

