/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.komaruholograms.util;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Display;
import ru.auriny.komaruholograms.KomaruHolograms;
import ru.auriny.komaruholograms.data.HologramData;
import ru.auriny.komaruholograms.data.HologramSaveData;
import ru.auriny.komaruholograms.data.PlaceholderStore;

public class PlaceholderProcessor {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{(.+?)\\}");

    public static String process(String id, Display.TextDisplay display) {
        ServerLevel level;
        HologramSaveData saveData;
        HologramData data = null;
        Iterator iterator = display.m_9236_().m_7654_().m_129785_().iterator();
        while (iterator.hasNext() && (data = (saveData = HologramSaveData.get(level = (ServerLevel)iterator.next())).getAll().get(id)) == null) {
        }
        if (data == null) {
            KomaruHolograms.LOGGER.warn("No HologramData found for id '{}'", (Object)id);
            return "";
        }
        String raw = data.text();
        if (raw == null || raw.isEmpty()) {
            KomaruHolograms.LOGGER.warn("Empty raw text for id '{}'", (Object)id);
            return "";
        }
        KomaruHolograms.LOGGER.debug("Processing {}: raw = {}", (Object)id, (Object)raw);
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(raw);
        StringBuilder buffer = new StringBuilder();
        while (matcher.find()) {
            String key = matcher.group(1);
            String replacement = PlaceholderStore.get(key);
            if (replacement == null || replacement.isEmpty()) {
                replacement = "";
            }
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(replacement));
            KomaruHolograms.LOGGER.debug("Trying to replace key '{}' -> '{}'", (Object)key, (Object)replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }
}

