/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.loot;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.impl.loot.modifier.AdditionLootModifier;
import org.moddingx.libx.impl.loot.modifier.RemovalLootModifier;
import org.moddingx.libx.mod.ModX;

public abstract class GlobalLootProviderBase
extends GlobalLootModifierProvider {
    protected final ModX mod;

    public GlobalLootProviderBase(DatagenContext ctx) {
        super(ctx.output(), ctx.mod().modid);
        this.mod = ctx.mod();
    }

    protected abstract void setup();

    protected final void start() {
        this.setup();
    }

    @Nonnull
    public String m_6055_() {
        return this.mod.modid + " loot modifiers";
    }

    public LootModifierBuilder addition(String name, ResourceLocation lootTable) {
        return this.modifier(name, conditions -> new AdditionLootModifier(lootTable, (LootItemCondition)conditions));
    }

    public LootModifierBuilder removal(String name, Item ... items) {
        return this.modifier(name, conditions -> new RemovalLootModifier(List.of(items), (LootItemCondition)conditions));
    }

    public LootModifierBuilder modifier(String name, Function<LootItemCondition[], ? extends LootModifier> factory) {
        return new LootModifierBuilder(name, factory);
    }

    public LootConditionsBuilder conditions() {
        return new LootConditionsBuilder();
    }

    public class LootModifierBuilder
    extends AnyLootConditionsBuilder<LootModifierBuilder> {
        private final String name;
        private final Function<LootItemCondition[], ? extends LootModifier> factory;

        private LootModifierBuilder(String name, Function<LootItemCondition[], ? extends LootModifier> factory) {
            this.name = name;
            this.factory = factory;
        }

        @Override
        protected LootModifierBuilder self() {
            return this;
        }

        public void build() {
            GlobalLootProviderBase.this.add(this.name, (IGlobalLootModifier)this.factory.apply((LootItemCondition[])this.buildConditions().toArray(LootItemCondition[]::new)));
        }
    }

    public static class LootConditionsBuilder
    extends AnyLootConditionsBuilder<LootConditionsBuilder> {
        private LootConditionsBuilder() {
        }

        @Override
        protected LootConditionsBuilder self() {
            return this;
        }
    }

    public static abstract class AnyLootConditionsBuilder<T extends AnyLootConditionsBuilder<T>> {
        private final List<LootItemCondition> conditions = new ArrayList<LootItemCondition>();

        private AnyLootConditionsBuilder() {
        }

        protected abstract T self();

        public T or(LootConditionsBuilder conditions) {
            return this.condition(AnyOfCondition.m_285758_((LootItemCondition.Builder[])conditions.buildConditionBuilders()).m_6409_());
        }

        public T forLootTable(String lootTableNamespace, String lootTablePath) {
            return this.forLootTable(new ResourceLocation(lootTableNamespace, lootTablePath));
        }

        public T forLootTable(ResourceLocation lootTable) {
            return this.condition(LootTableIdCondition.builder((ResourceLocation)lootTable).m_6409_());
        }

        public T condition(LootItemCondition condition) {
            this.conditions.add(condition);
            return this.self();
        }

        public T inverted() {
            if (this.conditions.isEmpty()) {
                throw new IllegalStateException("Can't invert last loot condition: No conditions.");
            }
            LootItemCondition cond = this.conditions.remove(this.conditions.size() - 1);
            this.conditions.add(InvertedLootItemCondition.m_81694_(() -> cond).m_6409_());
            return this.self();
        }

        public List<LootItemCondition> buildConditions() {
            return List.copyOf(this.conditions);
        }

        private LootItemCondition.Builder[] buildConditionBuilders() {
            return (LootItemCondition.Builder[])this.conditions.stream().map(condition -> () -> condition).toArray(LootItemCondition.Builder[]::new);
        }
    }
}

