/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.menu;

import com.mojang.datafixers.util.Function4;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class MenuBase
extends AbstractContainerMenu {
    public final IItemHandler playerInventory;

    protected MenuBase(@Nullable MenuType<?> type, int id, Inventory inventory) {
        super(type, id);
        this.playerInventory = new InvWrapper((Container)inventory);
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    protected int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        return this.addSlotBox(handler, index, x, y, horAmount, dx, verAmount, dy, (Function4<IItemHandler, Integer, Integer, Integer, Slot>)((Function4)SlotItemHandler::new));
    }

    protected int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        return this.addSlotRange(handler, index, x, y, amount, dx, (Function4<IItemHandler, Integer, Integer, Integer, Slot>)((Function4)SlotItemHandler::new));
    }

    protected int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy, Function4<IItemHandler, Integer, Integer, Integer, Slot> slotFactory) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx, slotFactory);
            y += dy;
        }
        return index;
    }

    protected int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx, Function4<IItemHandler, Integer, Integer, Integer, Slot> slotFactory) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)slotFactory.apply((Object)handler, (Object)index, (Object)x, (Object)y));
            x += dx;
            ++index;
        }
        return index;
    }

    protected boolean m_38903_(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack content;
        Slot slot;
        int idx;
        boolean success = false;
        if (stack.m_41753_()) {
            int n = idx = reverseDirection ? endIndex - 1 : startIndex;
            while (!stack.m_41619_() && !(!reverseDirection ? idx >= endIndex : idx < startIndex)) {
                slot = (Slot)this.f_38839_.get(idx);
                content = slot.m_7993_();
                if (!content.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)content) && slot.m_5857_(stack)) {
                    int maxSize;
                    int totalCount = content.m_41613_() + stack.m_41613_();
                    if (totalCount <= (maxSize = Math.min(slot.m_6641_(), stack.m_41741_()))) {
                        stack.m_41764_(0);
                        content.m_41764_(totalCount);
                        slot.m_6654_();
                        success = true;
                    } else if (content.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - content.m_41613_());
                        content.m_41764_(maxSize);
                        slot.m_6654_();
                        success = true;
                    }
                }
                idx += reverseDirection ? -1 : 1;
            }
        }
        if (!stack.m_41619_()) {
            int n = idx = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? idx >= endIndex : idx < startIndex)) {
                slot = (Slot)this.f_38839_.get(idx);
                content = slot.m_7993_();
                if (content.m_41619_() && slot.m_5857_(stack)) {
                    if (stack.m_41613_() > slot.m_6641_()) {
                        slot.m_5852_(stack.m_41620_(slot.m_6641_()));
                    } else {
                        slot.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot.m_6654_();
                    success = true;
                    break;
                }
                idx += reverseDirection ? -1 : 1;
            }
        }
        return success;
    }
}

