/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.tags.TagManager;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.DumpAllTagsCommand;
import slimeknights.mantle.command.MantleCommand;
import slimeknights.mantle.command.RegistryArgument;
import slimeknights.mantle.command.ViewTagCommand;

public class DumpTagCommand {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Dynamic2CommandExceptionType ERROR_READING_TAG = new Dynamic2CommandExceptionType((type, name) -> Component.m_237110_((String)"command.mantle.dump_tag.read_error", (Object[])new Object[]{type, name}));
    private static final Component SUCCESS_LOG = Component.m_237115_((String)"command.mantle.dump_tag.success_log");

    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)subCommand.requires(sender -> sender.m_6761_(1))).then(Commands.m_82129_((String)"type", RegistryArgument.registry()).suggests(MantleCommand.REGISTRY).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(MantleCommand.VALID_TAGS).executes(context -> DumpTagCommand.run((CommandContext<CommandSourceStack>)context, Action.LOG))).then(Commands.m_82127_((String)"log").executes(context -> DumpTagCommand.run((CommandContext<CommandSourceStack>)context, Action.LOG)))).then(Commands.m_82127_((String)"save").executes(context -> DumpTagCommand.run((CommandContext<CommandSourceStack>)context, Action.SAVE)))).then(Commands.m_82127_((String)"sources").executes(context -> DumpTagCommand.run((CommandContext<CommandSourceStack>)context, Action.SOURCES)))));
    }

    private static int run(CommandContext<CommandSourceStack> context, Action action) throws CommandSyntaxException {
        return DumpTagCommand.runGeneric(context, RegistryArgument.getResult(context, "type"), action);
    }

    public static void parseTag(List<Resource> resources, List<TagLoader.EntryWithSource> list, ResourceLocation regName, ResourceLocation tagName, ResourceLocation path) {
        for (Resource resource : resources) {
            String packId = resource.m_215506_();
            try {
                BufferedReader reader = resource.m_215508_();
                try {
                    JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    TagFile tagfile = (TagFile)TagFile.f_215958_.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json)).getOrThrow(false, arg_0 -> ((Logger)Mantle.logger).error(arg_0));
                    if (tagfile.f_215960_()) {
                        list.clear();
                    }
                    tagfile.f_215959_().forEach(tag -> list.add(new TagLoader.EntryWithSource(tag, packId)));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException | RuntimeException ex) {
                Mantle.logger.error("Couldn't read {} tag list {} from {} in data pack {}", (Object)regName, (Object)tagName, (Object)path, (Object)packId, (Object)ex);
            }
        }
    }

    public static String tagToJson(List<TagLoader.EntryWithSource> entries) {
        return GSON.toJson((JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(entries.stream().map(TagLoader.EntryWithSource::f_216042_).toList(), true)).getOrThrow(false, arg_0 -> ((Logger)Mantle.logger).error(arg_0)));
    }

    public static void saveTag(List<TagLoader.EntryWithSource> entries, Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(DumpTagCommand.tagToJson(entries));
            }
        }
        catch (IOException ex) {
            Mantle.logger.error("Couldn't save tag to {}", (Object)path, (Object)ex);
        }
    }

    private static <T> int runGeneric(CommandContext<CommandSourceStack> context, Registry<T> registry, Action action) throws CommandSyntaxException {
        ResourceLocation path;
        ResourceLocation regName = registry.m_123023_().m_135782_();
        ResourceLocation name = (ResourceLocation)context.getArgument("name", ResourceLocation.class);
        ResourceManager manager = ((CommandSourceStack)context.getSource()).m_81377_().m_177941_();
        List resources = manager.m_213829_(path = new ResourceLocation(name.m_135827_(), TagManager.m_203918_((ResourceKey)registry.m_123023_()) + "/" + name.m_135815_() + ".json"));
        if (resources.isEmpty() && registry.m_203431_(TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)name)).isEmpty()) {
            throw ViewTagCommand.TAG_NOT_FOUND.create((Object)regName, (Object)name);
        }
        ArrayList<TagLoader.EntryWithSource> list = new ArrayList<TagLoader.EntryWithSource>();
        DumpTagCommand.parseTag(resources, list, regName, name, path);
        switch (action) {
            case SAVE: {
                File output = new File(DumpAllTagsCommand.getOutputFile(context), path.m_135827_() + "/" + path.m_135815_());
                DumpTagCommand.saveTag(list, output.toPath());
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.mantle.dump_tag.success_log", (Object[])new Object[]{regName, name, DumpAllTagsCommand.getOutputComponent(output)}), true);
                break;
            }
            case LOG: {
                MutableComponent message = Component.m_237110_((String)"command.mantle.dump_tag.success", (Object[])new Object[]{regName, name});
                ((CommandSourceStack)context.getSource()).m_288197_(() -> DumpTagCommand.lambda$runGeneric$8((Component)message), true);
                Mantle.logger.info("Tag dump of {} tag '{}':\n{}", (Object)regName, (Object)name, (Object)DumpTagCommand.tagToJson(list));
                break;
            }
            case SOURCES: {
                MutableComponent message = Component.m_237110_((String)"command.mantle.dump_tag.success", (Object[])new Object[]{regName, name});
                ((CommandSourceStack)context.getSource()).m_288197_(() -> DumpTagCommand.lambda$runGeneric$9((Component)message), true);
                StringBuilder builder = new StringBuilder();
                builder.append("Tag list dump of ").append(regName).append(" tag ").append(name).append(" with sources:");
                for (TagLoader.EntryWithSource entry : list) {
                    builder.append("\n* '").append(entry.f_216042_()).append("' from '").append(entry.f_216043_()).append('\'');
                }
                Mantle.logger.info(builder.toString());
            }
        }
        return resources.size();
    }

    private static /* synthetic */ Component lambda$runGeneric$9(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$runGeneric$8(Component message) {
        return message;
    }

    private static enum Action {
        SAVE,
        LOG,
        SOURCES;

    }
}

