/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.interfaces;

import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import mekanism.common.tile.interfaces.IHasMode;
import net.minecraft.network.chat.Component;

public interface IFluidContainerManager
extends IHasMode {
    public ContainerEditMode getContainerEditMode();

    @NothingNullByDefault
    public static enum ContainerEditMode implements IIncrementalEnum<ContainerEditMode>,
    IHasTextComponent
    {
        BOTH(MekanismLang.FLUID_CONTAINER_BOTH),
        FILL(MekanismLang.FLUID_CONTAINER_FILL),
        EMPTY(MekanismLang.FLUID_CONTAINER_EMPTY);

        private static final ContainerEditMode[] MODES;
        private final ILangEntry langEntry;

        private ContainerEditMode(ILangEntry langEntry) {
            this.langEntry = langEntry;
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translate(new Object[0]);
        }

        @Override
        public ContainerEditMode byIndex(int index) {
            return ContainerEditMode.byIndexStatic(index);
        }

        public static ContainerEditMode byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        static {
            MODES = ContainerEditMode.values();
        }
    }
}

