/*
 * Decompiled with CFR 0.152.
 */
package com.black_dog20.servertabinfo.common.network.packets;

import com.black_dog20.servertabinfo.client.ClientDataManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketPlayers {
    private Map<UUID, ResourceLocation> playerDims;

    public PacketPlayers(Map<UUID, ResourceLocation> playerDims) {
        this.playerDims = playerDims;
    }

    public static void encode(PacketPlayers msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.playerDims.size());
        for (Map.Entry<UUID, ResourceLocation> playerKvP : msg.playerDims.entrySet()) {
            buffer.m_130077_(playerKvP.getKey());
            buffer.m_130085_(playerKvP.getValue());
        }
    }

    public static PacketPlayers decode(FriendlyByteBuf buffer) {
        HashMap<UUID, ResourceLocation> map = new HashMap<UUID, ResourceLocation>();
        int length = buffer.readInt();
        for (int i = 0; i < length; ++i) {
            map.put(buffer.m_130259_(), buffer.m_130281_());
        }
        return new PacketPlayers(map);
    }

    public static class Handler {
        public static void handle(PacketPlayers msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                ClientDataManager.PLAYER_DIMENSIONS = msg.playerDims;
            }));
            ctx.get().setPacketHandled(true);
        }
    }
}

