/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.forge;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.enginehub.worldeditcui.WorldEditCUI;
import org.enginehub.worldeditcui.config.CUIConfiguration;
import org.enginehub.worldeditcui.event.listeners.CUIListenerChannel;
import org.enginehub.worldeditcui.event.listeners.CUIListenerWorldRender;
import org.enginehub.worldeditcui.forge.CUINetworking;
import org.enginehub.worldeditcui.forge.mixins.LevelRendererAccessor;
import org.enginehub.worldeditcui.forge.mixins.MinecraftAccess;
import org.enginehub.worldeditcui.render.OptifinePipelineProvider;
import org.enginehub.worldeditcui.render.PipelineProvider;
import org.enginehub.worldeditcui.render.VanillaPipelineProvider;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class WorldEditCUIForgeClient {
    private static final int DELAYED_HELO_TICKS = 10;
    public static final String MOD_ID = "worldeditcui";
    private static WorldEditCUIForgeClient instance;
    private static final String KEYBIND_CATEGORY_WECUI = "key.categories.worldeditcui";
    private final Lazy<KeyMapping> keyBindToggleUI = WorldEditCUIForgeClient.key("toggle", InputConstants.Type.KEYSYM, -1);
    private final Lazy<KeyMapping> keyBindClearSel = WorldEditCUIForgeClient.key("clear", InputConstants.Type.KEYSYM, -1);
    private final Lazy<KeyMapping> keyBindChunkBorder = WorldEditCUIForgeClient.key("chunk", InputConstants.Type.KEYSYM, -1);
    private static final List<PipelineProvider> RENDER_PIPELINES;
    private WorldEditCUI controller;
    private CUIListenerWorldRender worldRenderListener;
    private CUIListenerChannel channelListener;
    private Level lastWorld;
    private LocalPlayer lastPlayer;
    private boolean visible = true;
    private int delayedHelo = 0;

    private static Lazy<KeyMapping> key(String name, InputConstants.Type type, int code) {
        return Lazy.of(() -> new KeyMapping("key.worldeditcui." + name, type, code, KEYBIND_CATEGORY_WECUI));
    }

    public void onInitialize() {
        if (Boolean.getBoolean("wecui.debug.mixinaudit")) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
        instance = this;
    }

    public void onTick(Minecraft mc) {
        boolean clock;
        CUIConfiguration config = this.controller.getConfiguration();
        boolean inGame = mc.f_91074_ != null;
        boolean bl = clock = ((MinecraftAccess)mc).getTimer().f_92518_ > 0.0f;
        if (inGame && mc.f_91080_ == null) {
            while (((KeyMapping)this.keyBindToggleUI.get()).m_90859_()) {
                this.visible = !this.visible;
            }
            while (((KeyMapping)this.keyBindClearSel.get()).m_90859_()) {
                if (mc.f_91074_ != null) {
                    mc.f_91074_.f_108617_.m_246979_("/sel");
                }
                if (!config.isClearAllOnKey()) continue;
                this.controller.clearRegions();
            }
            while (((KeyMapping)this.keyBindChunkBorder.get()).m_90859_()) {
                this.controller.toggleChunkBorders();
            }
        }
        if (inGame && clock && this.controller != null) {
            if (mc.f_91073_ != this.lastWorld || mc.f_91074_ != this.lastPlayer) {
                this.lastWorld = mc.f_91073_;
                this.lastPlayer = mc.f_91074_;
                this.controller.getDebugger().debug("World change detected, sending new handshake");
                this.controller.clear();
                this.helo(mc.m_91403_());
                this.delayedHelo = 10;
                if (mc.f_91074_ != null && config.isPromiscuous()) {
                    mc.f_91074_.f_108617_.m_246979_("we cui");
                }
            }
            if (this.delayedHelo > 0) {
                --this.delayedHelo;
                if (this.delayedHelo == 0) {
                    this.helo(mc.m_91403_());
                }
            }
        }
    }

    public void onPluginMessage(FriendlyByteBuf data) {
        try {
            int readableBytes = data.readableBytes();
            if (readableBytes > 0) {
                String stringPayload = data.toString(0, data.readableBytes(), StandardCharsets.UTF_8);
                Minecraft.m_91087_().execute(() -> this.channelListener.onMessage(stringPayload));
            } else {
                this.getController().getDebugger().debug("Warning, invalid (zero length) payload received from server");
            }
        }
        catch (Exception ex) {
            this.getController().getDebugger().info("Error decoding payload from server", ex);
        }
    }

    public void onGameInitDone(Minecraft client) {
        this.controller = new WorldEditCUI();
        this.controller.initialise(client);
        this.worldRenderListener = new CUIListenerWorldRender(this.controller, client, RENDER_PIPELINES);
        this.channelListener = new CUIListenerChannel(this.controller);
    }

    public void onJoinGame(ClientPacketListener handler) {
        this.visible = true;
        this.controller.getDebugger().debug("Joined game, sending initial handshake");
        this.helo(handler);
    }

    public void onPostRenderEntities(float tickDelta) {
        if (this.visible) {
            this.worldRenderListener.onRender(tickDelta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWorldRenderEventAfterTranslucent(PoseStack poseStack, float partialTick, boolean advancedTranslucency) {
        if (this.controller == null) {
            return;
        }
        if (advancedTranslucency) {
            try {
                RenderSystem.getModelViewStack().m_85836_();
                RenderSystem.getModelViewStack().m_252931_(poseStack.m_85850_().m_252922_());
                RenderSystem.applyModelViewMatrix();
                Minecraft.m_91087_().f_91060_.m_109828_().m_83947_(false);
                WorldEditCUIForgeClient.getInstance().onPostRenderEntities(partialTick);
            }
            finally {
                Minecraft.m_91087_().m_91385_().m_83947_(false);
                RenderSystem.getModelViewStack().m_85849_();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWorldRenderEventLast(PoseStack poseStack, float partialTick, boolean advancedTranslucency) {
        if (this.controller == null) {
            return;
        }
        if (!advancedTranslucency) {
            try {
                RenderSystem.getModelViewStack().m_85836_();
                RenderSystem.getModelViewStack().m_252931_(poseStack.m_85850_().m_252922_());
                RenderSystem.applyModelViewMatrix();
                WorldEditCUIForgeClient.getInstance().onPostRenderEntities(partialTick);
            }
            finally {
                RenderSystem.getModelViewStack().m_85849_();
                RenderSystem.applyModelViewMatrix();
            }
        }
    }

    private void helo(ClientPacketListener handler) {
        String message = "v|4";
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"v|4", (Charset)StandardCharsets.UTF_8);
        CUINetworking.send(handler, new FriendlyByteBuf(buffer));
    }

    public WorldEditCUI getController() {
        return this.controller;
    }

    public static WorldEditCUIForgeClient getInstance() {
        return instance;
    }

    static {
        RENDER_PIPELINES = List.of(new OptifinePipelineProvider(), new VanillaPipelineProvider());
        new WorldEditCUIForgeClient().onInitialize();
    }

    public static class ForgeEventBusListener {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (WorldEditCUIForgeClient.instance.controller == null) {
                return;
            }
            if (event.phase == TickEvent.Phase.END) {
                WorldEditCUIForgeClient.getInstance().onTick(Minecraft.m_91087_());
            }
        }

        @SubscribeEvent
        public static void onPlayerJoin(ClientPlayerNetworkEvent.LoggingIn event) {
            if (WorldEditCUIForgeClient.instance.controller == null) {
                return;
            }
            WorldEditCUIForgeClient.getInstance().onJoinGame(event.getPlayer().f_108617_);
        }

        @SubscribeEvent
        public static void onRenderLevelStage(RenderLevelStageEvent event) {
            if (WorldEditCUIForgeClient.instance.controller == null) {
                return;
            }
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
                boolean bl = ((LevelRendererAccessor)event.getLevelRenderer()).getTransparencyChain() != null;
            } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
                // empty if block
            }
        }
    }

    public static class ModEventBusListener {
        @SubscribeEvent
        public static void registerBindings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)WorldEditCUIForgeClient.instance.keyBindToggleUI.get());
            event.register((KeyMapping)WorldEditCUIForgeClient.instance.keyBindChunkBorder.get());
            event.register((KeyMapping)WorldEditCUIForgeClient.instance.keyBindClearSel.get());
        }
    }
}

