/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.minecraft.client.renderer.GameRenderer;
import org.enginehub.worldeditcui.render.BufferBuilderRenderSink;
import org.enginehub.worldeditcui.render.PipelineProvider;
import org.enginehub.worldeditcui.render.RenderSink;
import org.slf4j.Logger;

public final class OptifinePipelineProvider
implements PipelineProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle SHADERS_ACTIVE_PROGRAM;
    private static final MethodHandle PROGRAM_GET_NAME;
    private static final MethodHandle CONFIG_IS_SHADERS;
    private static final MethodHandle SHADERS_BEGIN_LEASH;
    private static final MethodHandle SHADERS_END_LEASH;
    private static final MethodHandle SHADERS_IS_SHADOW_PASS;
    private static boolean optifineDisabled;

    static String activeProgram() {
        if (SHADERS_ACTIVE_PROGRAM == null || PROGRAM_GET_NAME == null) {
            return "<optifine not detected>";
        }
        try {
            return PROGRAM_GET_NAME.invoke(SHADERS_ACTIVE_PROGRAM.invoke());
        }
        catch (Throwable ex) {
            LOGGER.debug("Failed to query OptiFine shader program", ex);
            return "<program query failed>";
        }
    }

    @Override
    public String id() {
        return "optifine";
    }

    @Override
    public boolean available() {
        return SHADERS_END_LEASH != null && SHADERS_BEGIN_LEASH != null && CONFIG_IS_SHADERS != null && !optifineDisabled;
    }

    @Override
    public boolean shouldRender() {
        try {
            return !SHADERS_IS_SHADOW_PASS.invoke();
        }
        catch (Throwable thr) {
            optifineDisabled = true;
            LOGGER.error("Failed to render WECUI using OptiFine hooks", thr);
            return true;
        }
    }

    @Override
    public RenderSink provide() {
        return new BufferBuilderRenderSink(OptifineTypeFactory.INSTANCE, () -> {
            if (!this.available()) {
                return;
            }
            try {
                boolean shadersEnabled = CONFIG_IS_SHADERS.invoke();
                if (shadersEnabled) {
                    SHADERS_BEGIN_LEASH.invoke();
                }
            }
            catch (Throwable thr) {
                optifineDisabled = true;
                LOGGER.error("Failed to render WECUI using OptiFine hooks", thr);
            }
        }, () -> {
            if (!this.available()) {
                return;
            }
            try {
                boolean shadersEnabled = CONFIG_IS_SHADERS.invoke();
                if (shadersEnabled) {
                    SHADERS_END_LEASH.invoke();
                }
            }
            catch (Throwable thr) {
                optifineDisabled = true;
                LOGGER.error("Failed to render WECUI using OptiFine hooks", thr);
            }
        });
    }

    static {
        optifineDisabled = false;
        MethodHandle configIsShaders = null;
        MethodHandle shadersEndLeash = null;
        MethodHandle shadersBeginLeash = null;
        MethodHandle programGetName = null;
        MethodHandle shadersActiveProgram = null;
        MethodHandle shadersIsShadowPass = null;
        try {
            Class<?> config = Class.forName("net.optifine.Config");
            Class<?> shaders = Class.forName("net.optifine.shaders.Shaders");
            Class<?> program = Class.forName("net.optifine.shaders.Program");
            configIsShaders = LOOKUP.findStatic(config, "isShaders", MethodType.methodType(Boolean.TYPE));
            shadersEndLeash = LOOKUP.findStatic(shaders, "endLeash", MethodType.methodType(Void.TYPE));
            shadersBeginLeash = LOOKUP.findStatic(shaders, "beginLeash", MethodType.methodType(Void.TYPE));
            programGetName = LOOKUP.findVirtual(program, "getName", MethodType.methodType(String.class));
            shadersActiveProgram = LOOKUP.findStaticGetter(shaders, "activeProgram", program);
            shadersIsShadowPass = LOOKUP.findStaticGetter(shaders, "isShadowPass", Boolean.TYPE);
            LOGGER.debug("Optifine integration successfully initialized");
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException ignore) {
            optifineDisabled = true;
        }
        CONFIG_IS_SHADERS = configIsShaders;
        SHADERS_END_LEASH = shadersEndLeash;
        SHADERS_BEGIN_LEASH = shadersBeginLeash;
        PROGRAM_GET_NAME = programGetName;
        SHADERS_ACTIVE_PROGRAM = shadersActiveProgram;
        SHADERS_IS_SHADOW_PASS = shadersIsShadowPass;
    }

    public static class OptifineTypeFactory
    implements BufferBuilderRenderSink.TypeFactory {
        public static final OptifineTypeFactory INSTANCE = new OptifineTypeFactory();
        private static final BufferBuilderRenderSink.RenderType QUADS = new BufferBuilderRenderSink.RenderType(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_, GameRenderer::m_172811_);
        private static final BufferBuilderRenderSink.RenderType LINES = new BufferBuilderRenderSink.RenderType(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_, GameRenderer::m_172811_);
        private static final BufferBuilderRenderSink.RenderType LINES_LOOP = new BufferBuilderRenderSink.RenderType(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_, GameRenderer::m_172811_);

        private OptifineTypeFactory() {
        }

        @Override
        public BufferBuilderRenderSink.RenderType quads() {
            return QUADS;
        }

        @Override
        public BufferBuilderRenderSink.RenderType lines() {
            return LINES;
        }

        @Override
        public BufferBuilderRenderSink.RenderType linesLoop() {
            return LINES_LOOP;
        }
    }
}

