/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render.points;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.enginehub.worldeditcui.render.points.PointCube;
import org.enginehub.worldeditcui.util.Vector3;

public class PointCubeTracking
extends PointCube {
    private final Entity entity;
    private final double traceDistance;
    private int lastX;
    private int lastY;
    private int lastZ;

    public PointCubeTracking(Entity entity, double traceDistance) {
        super(0.0, 0.0, 0.0);
        this.entity = entity;
        this.traceDistance = traceDistance;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public Vector3 getPoint() {
        return this.point;
    }

    @Override
    public void updatePoint(float partialTicks) {
        HitResult res = this.entity.m_19907_(this.traceDistance, partialTicks, false);
        if (!(res instanceof BlockHitResult)) {
            return;
        }
        BlockPos pos = ((BlockHitResult)res).m_82425_();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (this.lastX != x || this.lastY != y || this.lastZ != z) {
            this.lastX = x;
            this.lastY = y;
            this.lastZ = z;
            this.point = new Vector3(x, y, z);
            this.box.setPosition(this.point.subtract(PointCube.MIN_VEC), this.point.add(PointCube.MAX_VEC));
            this.notifyObservers();
        }
    }
}

