/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.block.ZetaPaneBlock;
import org.violetmoon.zeta.registry.IZetaBlockColorProvider;
import org.violetmoon.zeta.registry.IZetaItemColorProvider;

public class ZetaInheritedPaneBlock
extends ZetaPaneBlock
implements IZetaBlock,
IZetaBlockColorProvider {
    public final IZetaBlock parent;

    public ZetaInheritedPaneBlock(IZetaBlock parent, String name, BlockBehaviour.Properties properties) {
        super(name, parent.getModule(), properties, null);
        this.parent = parent;
        if (this.module == null || parent.getModule() == null) {
            return;
        }
        parent.getModule().zeta().renderLayerRegistry.mock((Block)this, parent.getBlock());
    }

    public ZetaInheritedPaneBlock(IZetaBlock parent, BlockBehaviour.Properties properties) {
        this(parent, Objects.requireNonNull(parent.getModule(), (String)"Can only use this constructor on blocks with a ZetaModule").zeta().registryUtil.inheritQuark(parent, "%s_pane"), properties);
    }

    public ZetaInheritedPaneBlock(IZetaBlock parent) {
        this(parent, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parent.getBlock()));
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.parent.isEnabled();
    }

    @Override
    @Nullable
    public float[] getBeaconColorMultiplierZeta(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        BlockState parentState = this.parent.getBlock().m_49966_();
        return this.parent.getModule().zeta().blockExtensions.get(parentState).getBeaconColorMultiplierZeta(parentState, world, pos, beaconPos);
    }

    @Override
    @Nullable
    public String getBlockColorProviderName() {
        String string;
        IZetaBlock iZetaBlock = this.parent;
        if (iZetaBlock instanceof IZetaBlockColorProvider) {
            IZetaBlockColorProvider prov = (IZetaBlockColorProvider)((Object)iZetaBlock);
            string = prov.getBlockColorProviderName();
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getItemColorProviderName() {
        String string;
        IZetaBlock iZetaBlock = this.parent;
        if (iZetaBlock instanceof IZetaItemColorProvider) {
            IZetaItemColorProvider prov = (IZetaItemColorProvider)((Object)iZetaBlock);
            string = prov.getItemColorProviderName();
        } else {
            string = null;
        }
        return string;
    }
}

