/*
 * Decompiled with CFR 0.152.
 */
package appbot.forge.ae2;

import appbot.AppliedBotanics;
import appbot.ae2.ManaHelper;
import appbot.ae2.ManaKeyType;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import appeng.parts.p2p.P2PModels;
import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;

public class ManaP2PTunnelPart
extends CapabilityP2PTunnelPart<ManaP2PTunnelPart, ManaReceiver> {
    private static final P2PModels MODELS = new P2PModels(AppliedBotanics.id("part/mana_p2p_tunnel"));
    private final SparkAttachable sparkAttachable = new P2PSparkAttachable();

    public ManaP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem, BotaniaForgeCapabilities.MANA_RECEIVER);
        this.inputHandler = new InputHandler();
        this.outputHandler = this.emptyHandler = new EmptyHandler();
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Nullable
    public SparkAttachable getSparkAttachable() {
        return this.isOutput() ? null : this.sparkAttachable;
    }

    private class P2PSparkAttachable
    implements SparkAttachable {
        private P2PSparkAttachable() {
        }

        public boolean canAttachSpark(ItemStack stack) {
            return true;
        }

        public int getAvailableSpaceForMana() {
            int space = 0;
            for (ManaP2PTunnelPart output : ManaP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = output.getAdjacentCapability();
                try {
                    ManaReceiver receiver = (ManaReceiver)guard.get();
                    space += ManaHelper.getCapacity(receiver);
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return space;
        }

        public ManaSpark getAttachedSpark() {
            BlockPos sparkPos = ManaP2PTunnelPart.this.getHost().getLocation().getPos().m_7494_();
            List sparks = ManaP2PTunnelPart.this.getLevel().m_6443_(Entity.class, new AABB(sparkPos, sparkPos.m_7918_(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
            if (sparks.size() == 1) {
                return (ManaSpark)sparks.get(0);
            }
            return null;
        }

        public boolean areIncomingTranfersDone() {
            for (ManaP2PTunnelPart output : ManaP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = output.getAdjacentCapability();
                try {
                    ManaReceiver receiver = (ManaReceiver)guard.get();
                    if (!receiver.canReceiveManaFromBursts() || receiver.isFull()) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return false;
        }
    }

    private class InputHandler
    implements ManaReceiver,
    ManaPool {
        private InputHandler() {
        }

        public Level getManaReceiverLevel() {
            return ManaP2PTunnelPart.this.getLevel();
        }

        public BlockPos getManaReceiverPos() {
            return ManaP2PTunnelPart.this.getHost().getLocation().getPos();
        }

        public int getCurrentMana() {
            return 0;
        }

        public boolean isFull() {
            for (ManaP2PTunnelPart output : ManaP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = output.getAdjacentCapability();
                try {
                    if (((ManaReceiver)guard.get()).isFull()) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return true;
        }

        public void receiveMana(int mana) {
            if (mana <= 0) {
                return;
            }
            List outputs = ManaP2PTunnelPart.this.getOutputStream().filter(part -> {
                try (CapabilityP2PTunnelPart.CapabilityGuard guard = ((ManaP2PTunnelPart)part).getAdjacentCapability();){
                    ManaReceiver receiver = (ManaReceiver)guard.get();
                    boolean bl = receiver.canReceiveManaFromBursts() && !receiver.isFull();
                    return bl;
                }
            }).collect(Collectors.toList());
            if (outputs.isEmpty()) {
                return;
            }
            Collections.shuffle(outputs);
            ManaP2PTunnelPart.this.deductTransportCost(mana / 100, ManaKeyType.TYPE);
            int manaForEach = mana / outputs.size();
            int spill = mana % outputs.size();
            for (ManaP2PTunnelPart output : outputs) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = output.getAdjacentCapability();
                try {
                    ((ManaReceiver)guard.get()).receiveMana(manaForEach + (spill-- > 0 ? 1 : 0));
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
        }

        public boolean canReceiveManaFromBursts() {
            for (ManaP2PTunnelPart output : ManaP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard guard = output.getAdjacentCapability();
                try {
                    ManaReceiver result = (ManaReceiver)guard.get();
                    if (!result.canReceiveManaFromBursts()) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (guard == null) continue;
                    guard.close();
                }
            }
            return false;
        }

        public boolean isOutputtingPower() {
            return false;
        }

        public int getMaxMana() {
            return ManaP2PTunnelPart.this.getOutputStream().map(part -> {
                try (CapabilityP2PTunnelPart.CapabilityGuard guard = ((ManaP2PTunnelPart)part).getAdjacentCapability();){
                    Integer n = ManaHelper.getCapacity((ManaReceiver)guard.get());
                    return n;
                }
            }).reduce(0, Integer::sum);
        }

        public Optional<DyeColor> getColor() {
            return Optional.of(DyeColor.PURPLE);
        }

        public void setColor(Optional<DyeColor> color) {
        }
    }

    private class EmptyHandler
    implements ManaReceiver {
        private EmptyHandler() {
        }

        public Level getManaReceiverLevel() {
            return ManaP2PTunnelPart.this.getLevel();
        }

        public BlockPos getManaReceiverPos() {
            return ManaP2PTunnelPart.this.getHost().getLocation().getPos();
        }

        public int getCurrentMana() {
            return 0;
        }

        public boolean isFull() {
            return true;
        }

        public void receiveMana(int mana) {
        }

        public boolean canReceiveManaFromBursts() {
            return false;
        }
    }
}

