/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.buttons;

import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.client.gui.buttons.ANButton;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

@OnlyIn(value=Dist.CLIENT)
public class GlyphButton
extends ANButton {
    public AbstractSpellPart abstractSpellPart;
    public List<SpellValidationError> validationErrors;

    public GlyphButton(int x, int y, AbstractSpellPart abstractSpellPart, Button.OnPress onPress) {
        super(x, y, 16, 16, onPress);
        this.abstractSpellPart = abstractSpellPart;
        this.validationErrors = new LinkedList<SpellValidationError>();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        RenderUtils.drawSpellPart(this.abstractSpellPart, graphics, this.f_93620_, this.f_93621_, 16, !this.validationErrors.isEmpty(), 0);
    }

    @Override
    public void getTooltip(List<Component> tip) {
        if (!GlyphRegistry.getSpellpartMap().containsKey(this.abstractSpellPart.getRegistryName())) {
            return;
        }
        AbstractSpellPart spellPart = GlyphRegistry.getSpellpartMap().get(this.abstractSpellPart.getRegistryName());
        tip.add((Component)Component.m_237115_((String)spellPart.getLocalizationKey()));
        for (SpellValidationError ve : this.validationErrors) {
            tip.add((Component)ve.makeTextComponentAdding().m_130940_(ChatFormatting.RED));
        }
        if (Screen.m_96638_()) {
            tip.add((Component)Component.m_237110_((String)"tooltip.ars_nouveau.glyph_level", (Object[])new Object[]{spellPart.getConfigTier().value}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.BLUE)));
            tip.add((Component)Component.m_237115_((String)"ars_nouveau.schools"));
            for (SpellSchool s : spellPart.spellSchools) {
                tip.add(s.getTextComponent());
            }
            tip.add(spellPart.getBookDescLang());
        } else {
            tip.add((Component)Component.m_237110_((String)"tooltip.ars_nouveau.hold_shift", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92090_.getKey().m_84875_()}));
            String modName = ModList.get().getModContainerById(spellPart.getRegistryName().m_135827_()).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(spellPart.getRegistryName().m_135827_());
            tip.add((Component)Component.m_237113_((String)modName).m_130940_(ChatFormatting.BLUE));
        }
    }
}

