/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.RedstoneRelay;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RedstoneRelayTile
extends ModdedTile
implements IWandable,
ITooltipProvider,
ITickable,
GeoBlockEntity {
    public List<BlockPos> poweredFrom = new ArrayList<BlockPos>();
    public List<BlockPos> powering = new ArrayList<BlockPos>();
    private int localPower;
    private int powerFromParentRelays;
    private int currentPower;
    @Nullable
    private BlockPos currentParent;
    boolean updateListeners;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RedstoneRelayTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.REDSTONE_RELAY_TILE.get(), pos, state);
    }

    public int getOutputPower() {
        return this.currentPower;
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && this.updateListeners) {
            this.calculateNewPower();
            this.updateListeners = false;
        }
    }

    public void onParentPowerChange(BlockPos pos, int newParentPower) {
        if (!this.poweredFrom.contains(pos)) {
            this.f_58857_.m_46672_(this.f_58858_, (Block)BlockRegistry.REDSTONE_RELAY.get());
            return;
        }
        if (pos.equals((Object)this.currentParent)) {
            this.powerFromParentRelays = newParentPower;
            this.calculateNewPower();
        } else if (newParentPower > this.powerFromParentRelays) {
            this.currentParent = pos.m_7949_();
            this.powerFromParentRelays = newParentPower;
            this.calculateNewPower();
        }
        this.f_58857_.m_46672_(this.f_58858_, (Block)BlockRegistry.REDSTONE_RELAY.get());
    }

    public void calculateNewPower() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        int oldPower = this.currentPower;
        int newPower = this.localPower;
        for (BlockPos pos : this.poweredFrom) {
            RedstoneRelayTile redstoneRelayTile;
            BlockEntity blockEntity;
            if (!this.f_58857_.m_46749_(pos) || !((blockEntity = this.f_58857_.m_7702_(pos)) instanceof RedstoneRelayTile) || (redstoneRelayTile = (RedstoneRelayTile)blockEntity).getOutputPower() <= this.localPower) continue;
            newPower = redstoneRelayTile.getOutputPower();
            this.currentParent = pos.m_7949_();
            this.powerFromParentRelays = redstoneRelayTile.getOutputPower();
        }
        if (newPower != oldPower) {
            this.setNewPower(newPower);
        }
    }

    protected void setNewPower(int power) {
        this.currentPower = power;
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_);
        BlockRegistry.REDSTONE_RELAY.get();
        if (!blockState.m_61138_((Property)RedstoneRelay.POWER)) {
            return;
        }
        BlockState blockState2 = this.f_58857_.m_8055_(this.f_58858_);
        BlockRegistry.REDSTONE_RELAY.get();
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState2.m_61124_((Property)RedstoneRelay.POWER, (Comparable)Integer.valueOf(power)), 3);
        this.updateBlock();
        this.f_58857_.m_46672_(this.f_58858_, (Block)BlockRegistry.REDSTONE_RELAY.get());
        this.updateListeners();
    }

    @Override
    public boolean updateBlock() {
        return super.updateBlock();
    }

    public void updateListeners() {
        for (BlockPos pos : this.powering) {
            BlockEntity blockEntity;
            if (!this.f_58857_.m_46749_(pos) || !((blockEntity = this.f_58857_.m_7702_(pos)) instanceof RedstoneRelayTile)) continue;
            RedstoneRelayTile redstoneRelayTile = (RedstoneRelayTile)blockEntity;
            redstoneRelayTile.onParentPowerChange(this.f_58858_, this.currentPower);
        }
    }

    public void onParentRemoved(BlockPos pos) {
        this.poweredFrom.remove(pos);
        this.updateBlock();
        if (this.currentParent != null && this.currentParent.equals((Object)pos)) {
            this.calculateNewPower();
        }
    }

    public void m_7651_() {
        super.m_7651_();
    }

    @Override
    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || this.f_58857_.f_46443_ || storedPos.equals((Object)this.m_58899_()) || !(this.f_58857_.m_7702_(storedPos) instanceof RedstoneRelayTile)) {
            return;
        }
        if (BlockUtil.distanceFrom(storedPos, this.f_58858_) <= (double)this.getMaxDistance()) {
            if (this.poweredFrom.contains(storedPos = storedPos.m_7949_())) {
                this.poweredFrom.remove(storedPos);
            } else {
                this.poweredFrom.add(storedPos);
            }
            this.updateListeners = true;
            this.updateBlock();
        }
    }

    public int getMaxDistance() {
        return 30;
    }

    @Override
    public void onFinishedConnectionFirst(@javax.annotation.Nullable BlockPos storedPos, @javax.annotation.Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || this.f_58857_.f_46443_ || storedPos.equals((Object)this.m_58899_()) || !(this.f_58857_.m_7702_(storedPos) instanceof RedstoneRelayTile)) {
            return;
        }
        if (BlockUtil.distanceFrom(storedPos, this.f_58858_) <= (double)this.getMaxDistance()) {
            if (this.powering.contains(storedPos = storedPos.m_7949_())) {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237110_((String)"ars_nouveau.connections.remove", (Object[])new Object[]{DominionWand.getPosString(storedPos)}));
                this.powering.remove(storedPos);
            } else {
                PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237110_((String)"ars_nouveau.connections.send", (Object[])new Object[]{DominionWand.getPosString(storedPos)}));
                this.powering.add(storedPos);
                ParticleUtil.beam(storedPos, this.f_58858_, this.f_58857_);
            }
            this.updateListeners = true;
            this.updateBlock();
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.connections.fail"));
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.poweredFrom = new ArrayList<BlockPos>();
        this.powering = new ArrayList<BlockPos>();
        this.currentParent = null;
        ListTag listTag = pTag.m_128437_("poweredFrom", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag tag = listTag.m_128728_(i);
            this.poweredFrom.add(BlockPos.m_122022_((long)tag.m_128454_("pos")));
        }
        ListTag poweringTag = pTag.m_128437_("powering", 10);
        for (int i = 0; i < poweringTag.size(); ++i) {
            CompoundTag tag = poweringTag.m_128728_(i);
            this.powering.add(BlockPos.m_122022_((long)tag.m_128454_("pos")));
        }
        this.localPower = pTag.m_128451_("localPower");
        this.currentPower = pTag.m_128451_("currentPower");
        this.powerFromParentRelays = pTag.m_128451_("powerFromParentRelays");
        if (pTag.m_128441_("currentParent")) {
            this.currentParent = BlockPos.m_122022_((long)pTag.m_128454_("currentParent"));
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag listTag = new ListTag();
        for (BlockPos pos : this.poweredFrom) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128356_("pos", pos.m_121878_());
            listTag.add((Object)posTag);
        }
        tag.m_128365_("poweredFrom", (Tag)listTag);
        ListTag poweringTag = new ListTag();
        for (BlockPos pos : this.powering) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128356_("pos", pos.m_121878_());
            poweringTag.add((Object)posTag);
        }
        tag.m_128365_("powering", (Tag)poweringTag);
        tag.m_128405_("localPower", this.localPower);
        tag.m_128405_("currentPower", this.currentPower);
        tag.m_128405_("powerFromParentRelays", this.powerFromParentRelays);
        if (this.currentParent != null) {
            tag.m_128356_("currentParent", this.currentParent.m_121878_());
        }
    }

    public int getLocalPower() {
        return this.localPower;
    }

    public void setLocalPower(int newLocalPower) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (newLocalPower != this.localPower) {
            this.localPower = newLocalPower;
            this.calculateNewPower();
        }
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237113_((String)("current power: " + this.currentPower)));
        if (this.powering.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.relay.no_to"));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.relay.one_to", (Object[])new Object[]{this.powering.size()}));
        }
        if (this.poweredFrom.isEmpty()) {
            tooltip.add((Component)Component.m_237115_((String)"ars_nouveau.relay.no_from"));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.powered_from", (Object[])new Object[]{this.poweredFrom.size()}));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "rotate_controller", 0, this::idlePredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "float_controller", 0, this::floatPredicate)});
    }

    private <P extends GeoAnimatable> PlayState idlePredicate(AnimationState<P> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("floating"));
        return PlayState.CONTINUE;
    }

    private <P extends GeoAnimatable> PlayState floatPredicate(AnimationState<P> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("rotating"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public double getTick(Object o) {
        return 0.0;
    }
}

