/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.basic_discord_rich_presence.discord;

import info.u_team.basic_discord_rich_presence.BasicDiscordRichPresenceReference;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.IPCClient;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.DiscordBuild;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.RichPresence;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import java.time.OffsetDateTime;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class DiscordRichPresence {
    private static final IPCClient CLIENT = new IPCClient(427196986064764928L);
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static boolean isEnabled = false;
    private static final OffsetDateTime TIME = OffsetDateTime.now();
    public static State currentState = new State(EnumState.STARTUP);
    private static int errorCount = 0;
    private static final Timer TIMER = new Timer("Discord Rich Presence Timer Thread");
    private static TimerTask timerTask;
    private static DetailsCallback callback;

    public static void setDetailsCallback(DetailsCallback callback) {
        DiscordRichPresence.callback = callback;
    }

    public static void start() {
        executor.execute(() -> {
            try {
                CLIENT.connect(new DiscordBuild[0]);
                timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        DiscordRichPresence.setState(currentState);
                    }
                };
                TIMER.schedule(timerTask, 1000L, 120000L);
                isEnabled = true;
                BasicDiscordRichPresenceReference.LOGGER.info("Discord client found and connected.");
            }
            catch (NoDiscordClientException ex) {
                BasicDiscordRichPresenceReference.LOGGER.info("Discord client was not found.");
            }
        });
    }

    public static void stop() {
        executor.execute(() -> {
            boolean wasConnected = false;
            if (timerTask != null) {
                wasConnected = true;
                timerTask.cancel();
                timerTask = null;
            }
            try {
                CLIENT.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            errorCount = 0;
            isEnabled = false;
            if (wasConnected) {
                BasicDiscordRichPresenceReference.LOGGER.info("Discord client closed.");
            }
        });
    }

    public static void setIdling() {
        DiscordRichPresence.setState(new State(EnumState.MENU));
    }

    public static void setDimension(Level level) {
        DiscordRichPresence.setState(DiscordRichPresence.getStateFromDimension(level));
    }

    public static State getStateFromDimension(Level level) {
        ResourceLocation dimensionKey = level.m_46472_().m_135782_();
        if (dimensionKey.equals((Object)Level.f_46428_.m_135782_())) {
            return new State(EnumState.OVERWORLD);
        }
        if (dimensionKey.equals((Object)Level.f_46429_.m_135782_())) {
            return new State(EnumState.NETHER);
        }
        if (dimensionKey.equals((Object)Level.f_46430_.m_135782_())) {
            return new State(EnumState.END);
        }
        return new State(EnumState.DIM, dimensionKey.m_135815_());
    }

    public static void setState(State state) {
        executor.execute(() -> {
            block7: {
                currentState = state;
                RichPresence.Builder builder = new RichPresence.Builder();
                builder.setDetails(callback.getMinecraftVersion() + " with " + callback.getModSize() + " Mods");
                builder.setState(state.getState().getMessage(state.getReplace()));
                builder.setStartTimestamp(TIME);
                builder.setLargeImage(state.getState().getImageKey(), state.getState().getImageName(state.getReplace()));
                if (state.getState() == EnumState.MENU || state.getState() == EnumState.STARTUP) {
                    builder.setSmallImage("uteamcore", "U-Team Core");
                }
                try {
                    CLIENT.sendRichPresence(builder.build());
                }
                catch (Exception ex) {
                    try {
                        CLIENT.connect(new DiscordBuild[0]);
                        errorCount = 0;
                        CLIENT.sendRichPresence(builder.build());
                    }
                    catch (Exception ex2) {
                        try {
                            CLIENT.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (++errorCount <= 10) break block7;
                        BasicDiscordRichPresenceReference.LOGGER.info("Discord rich presence stopped cause connection is not working.");
                        DiscordRichPresence.stop();
                    }
                }
            }
        });
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static State getCurrent() {
        return currentState;
    }

    static {
        callback = DetailsCallback.DEFAULT;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> DiscordRichPresence.stop(), "Basic-Discord-Rich-Presence Stop Thread"));
    }

    public static interface DetailsCallback {
        public static final DetailsCallback DEFAULT = new DetailsCallback(){

            @Override
            public String getMinecraftVersion() {
                return Minecraft.m_91087_().m_91388_();
            }

            @Override
            public String getModSize() {
                return "?";
            }
        };

        public String getMinecraftVersion();

        public String getModSize();
    }

    public static class State {
        private final EnumState state;
        private final String replace;

        public State(EnumState state) {
            this(state, "");
        }

        public State(EnumState state, String replace) {
            this.state = state;
            this.replace = replace;
        }

        public EnumState getState() {
            return this.state;
        }

        public String getReplace() {
            return this.replace;
        }
    }

    public static enum EnumState {
        STARTUP("Starting Minecraft", "Minecraft", "minecraft"),
        MENU("Idling in menu", "Minecraft", "minecraft"),
        OVERWORLD("Dimension: Overworld", "Overworld", "world_overworld"),
        NETHER("Dimension: Nether", "Nether", "world_nether"),
        END("Dimension: The End", "The End", "world_the_end"),
        DIM("Dimension: %s", "%s", "world_dim");

        private final String message;
        private final String imagename;
        private final String imagekey;

        private EnumState(String message, String imagename, String imagekey) {
            this.message = message;
            this.imagename = imagename;
            this.imagekey = imagekey;
        }

        public String getMessage(String replace) {
            return this.message.replace("%s", replace);
        }

        public String getImageName(String replace) {
            return this.imagename.replace("%s", replace);
        }

        public String getImageKey() {
            return this.imagekey;
        }
    }
}

