/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.basic_discord_rich_presence.event;

import info.u_team.basic_discord_rich_presence.config.ClientConfig;
import info.u_team.basic_discord_rich_presence.discord.DiscordRichPresence;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class UpdateDiscordEventHandler {
    private static void setup(FMLCommonSetupEvent event) {
        if (((Boolean)ClientConfig.getInstance().discordRichPresence.get()).booleanValue()) {
            DiscordRichPresence.start();
        }
    }

    private static void onScreenInitPre(ScreenEvent.Init.Pre event) {
        DiscordRichPresence.State state;
        if (!DiscordRichPresence.isEnabled()) {
            return;
        }
        if ((event.getScreen() instanceof TitleScreen || event.getScreen() instanceof SelectWorldScreen || event.getScreen() instanceof JoinMultiplayerScreen) && ((state = DiscordRichPresence.getCurrent()) == null || state.getState() != DiscordRichPresence.EnumState.MENU)) {
            DiscordRichPresence.setIdling();
        }
    }

    private static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        LocalPlayer player;
        if (!DiscordRichPresence.isEnabled()) {
            return;
        }
        if (event.getEntity() instanceof LocalPlayer && (player = (LocalPlayer)event.getEntity()).m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
            DiscordRichPresence.setDimension(player.m_9236_());
        }
    }

    public static void registerMod(IEventBus bus) {
        bus.addListener(UpdateDiscordEventHandler::setup);
    }

    public static void registerForge(IEventBus bus) {
        bus.addListener(UpdateDiscordEventHandler::onScreenInitPre);
        bus.addListener(UpdateDiscordEventHandler::onEntityJoinLevel);
    }
}

