/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.item;

import com.teamabnormals.blueprint.core.util.item.ItemStackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.ForgeRegistries;

public final class CreativeModeTabContentsPopulator {
    private static final TreeMap<String, Entry> ENTRIES = new TreeMap();

    public static synchronized Entry mod(String id) {
        return ENTRIES.computeIfAbsent(id, key -> new Entry());
    }

    public static void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        ENTRIES.values().forEach(entry -> entry.onBuildCreativeModeTabContents(event));
    }

    public static final class Entry {
        private final HashMap<ResourceKey<CreativeModeTab>, ArrayList<CreativeModeTabContentsEditor>> keyedContentEditors = new HashMap();
        private final HashMap<Predicate<BuildCreativeModeTabContentsEvent>, ArrayList<CreativeModeTabContentsEditor>> otherContentEditors = new HashMap();
        private CreativeModeTab.TabVisibility visibility = CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
        private ArrayList<CreativeModeTabContentsEditor> currentEditors = null;

        public Entry visibility(CreativeModeTab.TabVisibility visibility) {
            this.visibility = visibility;
            return this;
        }

        public Entry tab(ResourceKey<CreativeModeTab> tabKey) {
            this.currentEditors = this.keyedContentEditors.computeIfAbsent(tabKey, key -> new ArrayList());
            return this;
        }

        public Entry predicate(Predicate<BuildCreativeModeTabContentsEvent> predicate) {
            this.currentEditors = this.otherContentEditors.computeIfAbsent(predicate, key -> new ArrayList());
            return this;
        }

        public Entry editor(CreativeModeTabContentsEditor editor) {
            this.currentEditors.add(editor);
            return this;
        }

        @SafeVarargs
        public final Entry addStacks(Supplier<ItemStack> ... items) {
            return this.editor(CreativeModeTabContentsEditor.forAllStacks(items, (event, stack) -> event.getEntries().put(stack, (Object)this.visibility)));
        }

        @SafeVarargs
        public final Entry addItems(Supplier<? extends ItemLike> ... items) {
            return this.addStacks(Entry.convertItemLikesToStacks(items));
        }

        @SafeVarargs
        public final Entry addStacksFirst(Supplier<ItemStack> ... items) {
            return this.editor(CreativeModeTabContentsEditor.forAllStacks(items, (event, stack) -> event.getEntries().putFirst(stack, (Object)this.visibility)));
        }

        @SafeVarargs
        public final Entry addItemsFirst(Supplier<? extends ItemLike> ... items) {
            return this.addStacksFirst(Entry.convertItemLikesToStacks(items));
        }

        @SafeVarargs
        public final Entry addStacksAfter(Predicate<ItemStack> predicate, Supplier<ItemStack> ... items) {
            return this.editor(event -> {
                MutableHashedLinkedMap entries = event.getEntries();
                for (Map.Entry entry : entries) {
                    ItemStack stack = (ItemStack)entry.getKey();
                    if (!predicate.test(stack)) continue;
                    CreativeModeTab.TabVisibility visibility = this.visibility;
                    for (Supplier item : items) {
                        ItemStack itemValue = (ItemStack)item.get();
                        entries.putAfter((Object)stack, (Object)itemValue, (Object)visibility);
                        stack = itemValue;
                    }
                    return;
                }
            });
        }

        @SafeVarargs
        public final Entry addItemsAfter(Predicate<ItemStack> predicate, Supplier<? extends ItemLike> ... items) {
            return this.addStacksAfter(predicate, Entry.convertItemLikesToStacks(items));
        }

        @SafeVarargs
        public final Entry addStacksBefore(Predicate<ItemStack> predicate, Supplier<ItemStack> ... items) {
            return this.editor(event -> {
                MutableHashedLinkedMap entries = event.getEntries();
                for (Map.Entry entry : entries) {
                    ItemStack stack = (ItemStack)entry.getKey();
                    if (!predicate.test(stack)) continue;
                    CreativeModeTab.TabVisibility visibility = this.visibility;
                    for (Supplier item : items) {
                        entries.putBefore((Object)stack, (Object)((ItemStack)item.get()), (Object)visibility);
                    }
                    return;
                }
            });
        }

        @SafeVarargs
        public final Entry addItemsBefore(Predicate<ItemStack> predicate, Supplier<? extends ItemLike> ... items) {
            return this.addStacksBefore(predicate, Entry.convertItemLikesToStacks(items));
        }

        @SafeVarargs
        public final Entry addStacksAlphabetically(Predicate<ItemStack> shouldCompareToStack, String trimRegex, Supplier<ItemStack> ... items) {
            return this.editor(event -> {
                MutableHashedLinkedMap entries = event.getEntries();
                TreeMap<String, ItemStack> treeMap = new TreeMap<String, ItemStack>();
                String lastPath = "";
                for (Map.Entry entry : entries) {
                    ItemStack stack = (ItemStack)entry.getKey();
                    ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                    if (location == null || !shouldCompareToStack.test(stack)) continue;
                    String path = location.m_135815_().replaceAll(trimRegex, "");
                    if (path.compareTo(lastPath) <= 0) break;
                    treeMap.putIfAbsent(path, stack);
                    lastPath = path;
                }
                CreativeModeTab.TabVisibility visibility = this.visibility;
                for (Supplier supplier : items) {
                    ItemStack stack = (ItemStack)supplier.get();
                    Optional key = ForgeRegistries.ITEMS.getResourceKey((Object)stack.m_41720_());
                    if (key.isEmpty()) continue;
                    String path = ((ResourceKey)key.get()).m_135782_().m_135815_().replace(trimRegex, "");
                    Map.Entry entry = treeMap.floorEntry(path);
                    if (entry != null) {
                        entries.putAfter((Object)((ItemStack)entry.getValue()), (Object)stack, (Object)visibility);
                    } else {
                        Map.Entry firstEntry = treeMap.firstEntry();
                        if (firstEntry != null) {
                            entries.putBefore((Object)((ItemStack)firstEntry.getValue()), (Object)stack, (Object)visibility);
                        } else {
                            entries.put((Object)stack, (Object)visibility);
                        }
                    }
                    treeMap.put(path, stack);
                }
            });
        }

        @Deprecated(forRemoval=true)
        public Entry addStacksAlphabetically(Predicate<ItemStack> shouldCompareToStack, Supplier<ItemStack> ... items) {
            return this.addStacksAlphabetically(shouldCompareToStack, "spawn_egg|pottery_sherd|_", items);
        }

        @SafeVarargs
        public final Entry addItemsAlphabetically(Predicate<ItemStack> shouldCompareToStack, String trimRegex, Supplier<? extends ItemLike> ... items) {
            return this.addStacksAlphabetically(shouldCompareToStack, trimRegex, Entry.convertItemLikesToStacks(items));
        }

        @SafeVarargs
        public final Entry addSpawnEggsAlphabetically(Supplier<? extends ItemLike> ... items) {
            return this.addItemsAlphabetically(ItemStackUtil.is(SpawnEggItem.class), "spawn_egg|_", items);
        }

        @SafeVarargs
        public final Entry addPotterySherdsAlphabetically(Supplier<? extends ItemLike> ... items) {
            return this.addItemsAlphabetically((ItemStack stack) -> stack.m_204117_(ItemTags.f_271220_), "pottery_sherd|_", items);
        }

        @Deprecated(forRemoval=true)
        public Entry addItemsAlphabetically(Predicate<ItemStack> shouldCompareToStack, Supplier<? extends ItemLike> ... items) {
            return this.addStacksAlphabetically(shouldCompareToStack, "spawn_egg|pottery_sherd|_", Entry.convertItemLikesToStacks(items));
        }

        private void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
            ArrayList<CreativeModeTabContentsEditor> editorsForKey = this.keyedContentEditors.get(event.getTabKey());
            if (editorsForKey != null) {
                editorsForKey.forEach(editor -> editor.edit(event));
            }
            this.otherContentEditors.forEach((eventPredicate, editors) -> {
                if (eventPredicate.test(event)) {
                    editors.forEach(editor -> editor.edit(event));
                }
            });
        }

        private static Supplier<ItemStack>[] convertItemLikesToStacks(Supplier<? extends ItemLike> ... items) {
            int length = items.length;
            Supplier[] newItems = new Supplier[length];
            for (int i = 0; i < length; ++i) {
                int finalI = i;
                newItems[i] = () -> new ItemStack((ItemLike)items[finalI].get());
            }
            return newItems;
        }
    }

    @FunctionalInterface
    public static interface CreativeModeTabContentsEditor {
        public void edit(BuildCreativeModeTabContentsEvent var1);

        public static CreativeModeTabContentsEditor forAllStacks(Supplier<ItemStack>[] items, BiConsumer<BuildCreativeModeTabContentsEvent, ItemStack> consumer) {
            return event -> {
                for (Supplier supplier : items) {
                    consumer.accept(event, (ItemStack)supplier.get());
                }
            };
        }
    }
}

