/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.blocks.pattern;

import appeng.api.config.Actionable;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.util.AECableType;
import appeng.hooks.ticking.TickHandler;
import appeng.me.helpers.BlockEntityNodeListener;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.lmor.botanicalextramachinery.ModBlocks;
import net.lmor.botanicalextramachinery.ModItems;
import net.lmor.botanicalextramachinery.blocks.base.RecipeTile;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalManaPool.BlockEntityManaPoolAdvanced;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalManaPool.BlockEntityManaPoolBase;
import net.lmor.botanicalextramachinery.blocks.tiles.mechanicalManaPool.BlockEntityManaPoolUpgraded;
import net.lmor.botanicalextramachinery.config.LibXClientConfig;
import net.lmor.botanicalextramachinery.config.LibXServerConfig;
import net.lmor.botanicalextramachinery.util.SettingPattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;
import org.moddingx.libx.crafting.RecipeHelper;
import org.moddingx.libx.inventory.BaseItemStackHandler;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class BlockEntityManaPoolPattern
extends RecipeTile<ManaInfusionRecipe>
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    private static List<Item> CACHED_CATALYSTS;
    private final int CATALYSTS_SLOT;
    private final int UPGRADE_SLOT;
    private final int FIRST_INPUT_SLOT;
    private final int LAST_INPUT_SLOT;
    private final int FIRST_OUTPUT_SLOT;
    private final int LAST_OUTPUT_SLOT;
    private final BaseItemStackHandler inventory;
    private final SettingPattern settingPattern;
    private final Boolean isUpgrade;
    private int cooldown = 0;
    private boolean checkWithCatalyst = false;
    private int timeCheckOutputSlot = LibXServerConfig.tickOutputSlots;
    private boolean setChangedQueued;
    private final IManagedGridNode mainNode = this.createMainNode().setVisualRepresentation((ItemLike)this.getItemFromBlockEntity()).setInWorldNode(true).setTagName("proxy");

    public BlockEntityManaPoolPattern(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int manaCap, int[] slots, boolean isUpgrade, int countCraft, SettingPattern config) {
        super(blockEntityType, BotaniaRecipeTypes.MANA_INFUSION_TYPE, pos, state, manaCap, slots[1], slots[3], countCraft);
        this.CATALYSTS_SLOT = slots[0];
        this.UPGRADE_SLOT = isUpgrade ? slots[5] : -1;
        this.FIRST_INPUT_SLOT = slots[1];
        this.LAST_INPUT_SLOT = slots[2];
        this.FIRST_OUTPUT_SLOT = slots[3];
        this.LAST_OUTPUT_SLOT = slots[4];
        this.inventory = isUpgrade ? BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> this.getCatalysts().contains(stack.m_41720_()), new int[]{this.CATALYSTS_SLOT}).validator(stack -> stack.m_41720_() == ModItems.catalystManaInfinity.m_5456_(), new int[]{this.UPGRADE_SLOT}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)BotaniaRecipeTypes.MANA_INFUSION_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).slotLimit(1, new int[]{this.CATALYSTS_SLOT, this.UPGRADE_SLOT}).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build() : BaseItemStackHandler.builder((int)(this.LAST_OUTPUT_SLOT + 1)).validator(stack -> this.getCatalysts().contains(stack.m_41720_()), new int[]{this.CATALYSTS_SLOT}).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), (RecipeType)BotaniaRecipeTypes.MANA_INFUSION_TYPE, (ItemStack)stack), Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_INPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_INPUT_SLOT + 1))).slotLimit(1, new int[]{this.CATALYSTS_SLOT}).output(Range.closedOpen((Comparable)Integer.valueOf(this.FIRST_OUTPUT_SLOT), (Comparable)Integer.valueOf(this.LAST_OUTPUT_SLOT + 1))).contentsChanged(() -> {
            this.m_6596_();
            this.setDispatchable();
            this.needsRecipeUpdate();
        }).build();
        this.settingPattern = config;
        this.isUpgrade = isUpgrade;
        this.setChangedQueued = false;
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (!this.getMainNode().isReady()) {
                this.getMainNode().create(this.f_58857_, this.m_58899_());
            }
            this.updateRecipeIfNeeded();
            if (this.getMainNode() != null && this.getMainNode().getNode() != null && this.getMainNode().isOnline()) {
                if (this.timeCheckOutputSlot <= 0) {
                    if (this.checkOutputSlots()) {
                        this.exportResultsItemsME();
                    }
                    this.timeCheckOutputSlot = LibXServerConfig.tickOutputSlots;
                } else {
                    --this.timeCheckOutputSlot;
                }
            }
            if (this.isUpgrade.booleanValue() && this.getMaxMana() != this.getCurrentMana() && !this.inventory.getStackInSlot(this.UPGRADE_SLOT).m_41619_()) {
                this.receiveMana(this.getMaxMana());
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                this.m_6596_();
                this.setDispatchable();
            }
            if (this.cooldown <= 0 && this.recipe != null) {
                this.craftRecipe();
            }
        } else if (this.f_58857_ != null && LibXClientConfig.RenderingVisualContent.all && this.settingPattern.getConfigBoolean("mechanicalManaPoolRender").booleanValue()) {
            double particleChance = (double)this.getCurrentMana() / (double)this.getMaxMana() * 0.1;
            if (Math.random() < particleChance) {
                float red = 0.0f;
                float green = 0.7764706f;
                float blue = 1.0f;
                WispParticleData data = WispParticleData.wisp((float)((float)Math.random() / 3.0f), (float)red, (float)green, (float)blue, (float)2.0f);
                this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.3 + this.f_58857_.f_46441_.m_188500_() * 0.4, (double)this.f_58858_.m_123342_() + 0.5 + this.f_58857_.f_46441_.m_188500_() * 0.25, (double)this.f_58858_.m_123343_() + 0.3 + this.f_58857_.f_46441_.m_188500_() * 0.4, 0.0, (double)(this.f_58857_.f_46441_.m_188501_() / 25.0f), 0.0);
            }
        }
    }

    @Override
    protected Predicate<Integer> getExtracts(Supplier<IItemHandlerModifiable> supplier) {
        return slot -> slot >= this.FIRST_OUTPUT_SLOT && slot <= this.LAST_OUTPUT_SLOT;
    }

    @Override
    @Nonnull
    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    protected void updateRecipe(BiConsumer<ItemStack, Integer> usedStacks) {
        this.recipe = null;
        this.checkWithCatalyst = true;
        super.updateRecipe(usedStacks);
        this.checkWithCatalyst = false;
        if (this.recipe == null) {
            super.updateRecipe(usedStacks);
        }
    }

    @Override
    protected boolean matchRecipe(ManaInfusionRecipe recipe, List<ItemStack> stacks) {
        Block catalyst;
        if (recipe.getManaToConsume() > this.getCurrentMana()) {
            return false;
        }
        Item catalystItem = this.checkWithCatalyst && !this.inventory.getStackInSlot(this.CATALYSTS_SLOT).m_41619_() ? this.inventory.getStackInSlot(this.CATALYSTS_SLOT).m_41720_() : null;
        Block block = catalyst = catalystItem == null ? null : Block.m_49814_(catalystItem);
        if (catalyst == null && recipe.getRecipeCatalyst() != null) {
            return false;
        }
        return (catalyst == null || recipe.getRecipeCatalyst() != null && recipe.getRecipeCatalyst().test(catalyst.m_49966_())) && super.matchRecipe(recipe, stacks);
    }

    @Override
    protected void onCrafted(ManaInfusionRecipe recipe, int countItemCraft) {
        this.cooldown = Math.max(1, this.settingPattern.getConfigInt("craftTime"));
        if (this.isUpgrade.booleanValue() && !this.inventory.getStackInSlot(this.UPGRADE_SLOT).m_41619_()) {
            return;
        }
        for (int i = 0; i < countItemCraft; ++i) {
            this.receiveMana(-recipe.getManaToConsume());
        }
    }

    @Override
    public int getComparatorOutput() {
        if (this.inventory.getStackInSlot(this.CATALYSTS_SLOT).m_41619_()) {
            return 0;
        }
        Item item = this.inventory.getStackInSlot(this.CATALYSTS_SLOT).m_41720_();
        return this.getCatalysts().contains(item) ? Mth.m_14045_((int)(1 + this.getCatalysts().indexOf(item)), (int)0, (int)15) : 0;
    }

    @Override
    public void receiveMana(int i) {
        if (this.inventory.getStackInSlot(this.CATALYSTS_SLOT).m_41720_() == BotaniaBlocks.manaVoid.m_5456_()) {
            super.receiveMana(Math.min(i, this.getAvailableSpaceForMana()));
        } else {
            super.receiveMana(i);
        }
        if (this.recipe == null && this.checkInputSlots()) {
            this.needsRecipeUpdate();
        }
    }

    private boolean checkInputSlots() {
        for (int i = this.FIRST_INPUT_SLOT; i <= this.LAST_INPUT_SLOT; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private boolean checkOutputSlots() {
        for (int i = this.FIRST_OUTPUT_SLOT; i <= this.LAST_OUTPUT_SLOT; ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFull() {
        return this.inventory.getStackInSlot(this.CATALYSTS_SLOT).m_41720_() != BotaniaBlocks.manaVoid.m_5456_() && super.isFull();
    }

    @Override
    public int getAvailableSpaceForMana() {
        return this.inventory.getStackInSlot(this.CATALYSTS_SLOT).m_41720_() == BotaniaBlocks.manaVoid.m_5456_() ? this.getMaxMana() : super.getAvailableSpaceForMana();
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.cooldown = nbt.m_128451_("cooldown");
        this.getMainNode().loadFromNBT(nbt);
        this.m_6596_();
        this.setDispatchable();
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("cooldown", this.cooldown);
        this.getMainNode().saveToNBT(nbt);
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            this.cooldown = nbt.m_128451_("cooldown");
        }
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("cooldown", this.cooldown);
        return nbt;
    }

    public static void invalidateCatalysts() {
        CACHED_CATALYSTS = null;
    }

    public List<Item> getCatalysts() {
        if (CACHED_CATALYSTS == null) {
            if (this.f_58857_ == null) {
                return List.of();
            }
            ArrayList catalysts = new ArrayList();
            this.f_58857_.m_7465_().m_44013_(BotaniaRecipeTypes.MANA_INFUSION_TYPE).forEach(recipe -> {
                if (recipe.getRecipeCatalyst() != null) {
                    recipe.getRecipeCatalyst().getDisplayedStacks().stream().map(ItemStack::m_41720_).forEach(item -> {
                        if (!catalysts.contains(item)) {
                            catalysts.add(item);
                        }
                    });
                }
            });
            CACHED_CATALYSTS = List.copyOf(catalysts);
        }
        return CACHED_CATALYSTS;
    }

    private BlockEntity getBlockEntity() {
        return this;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.getMainNode() != null) {
            this.getMainNode().destroy();
        }
    }

    protected IManagedGridNode createMainNode() {
        return GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)BlockEntityNodeListener.INSTANCE);
    }

    protected Item getItemFromBlockEntity() {
        BlockEntity blockEntity = this.getBlockEntity();
        if (blockEntity instanceof BlockEntityManaPoolBase) {
            return ModBlocks.baseManaPool.m_5456_();
        }
        if (blockEntity instanceof BlockEntityManaPoolUpgraded) {
            return ModBlocks.upgradedManaPool.m_5456_();
        }
        if (blockEntity instanceof BlockEntityManaPoolAdvanced) {
            return ModBlocks.advancedManaPool.m_5456_();
        }
        return ModBlocks.ultimateManaPool.m_5456_();
    }

    private Object setChangedAtEndOfTick(Level level) {
        this.m_6596_();
        this.setChangedQueued = false;
        return null;
    }

    @Nullable
    public IGridNode getGridNode(Direction direction) {
        return this.getMainNode().getNode();
    }

    public IManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public void saveChanges() {
        if (this.f_58857_ != null) {
            if (this.f_58857_.f_46443_) {
                this.m_6596_();
            } else {
                this.f_58857_.m_151543_(this.f_58858_);
                if (!this.setChangedQueued) {
                    TickHandler.instance().addCallable((LevelAccessor)null, this::setChangedAtEndOfTick);
                    this.setChangedQueued = true;
                }
            }
        }
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    private void exportResultsItemsME() {
        for (int slot = this.FIRST_OUTPUT_SLOT; slot <= this.LAST_OUTPUT_SLOT; ++slot) {
            int getCountExport;
            ItemStack stackInSlot = this.inventory.getStackInSlot(slot);
            if (stackInSlot.m_41619_() || (getCountExport = Math.toIntExact(this.getMainNode().getGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)stackInSlot), (long)stackInSlot.m_41613_(), Actionable.MODULATE, IActionSource.empty()))) <= 0) continue;
            stackInSlot.m_41774_(getCountExport);
            this.inventory.setStackInSlot(slot, stackInSlot);
        }
    }
}

