/*
 * Decompiled with CFR 0.152.
 */
package net.lmor.botanicalextramachinery.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.lmor.botanicalextramachinery.config.LibXClientConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.moddingx.libx.inventory.BaseItemStackHandler;

public class SlotInfo {
    private final Screen parent;
    private Map<Integer, int[]> slots = new HashMap<Integer, int[]>();
    private List<String> translatables = new ArrayList<String>();
    private static int width = 16;
    private static int height = 16;
    private int guiLeft;
    private int guiTop;

    public SlotInfo(Screen parent) {
        this.parent = parent;
    }

    public List<Integer> getSlotUpgrade() {
        if (this.slots == null) {
            return null;
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = 0; i < this.slots.size(); ++i) {
            String[] str = this.translatables.get(i).split("\\.");
            if (!Objects.equals(str[str.length - 1], "upgrade_slot")) continue;
            res.add(i);
        }
        return res;
    }

    public void setCoord(Map<Integer, int[]> slots) {
        if (slots != null) {
            this.slots = slots;
        }
    }

    public void setTranslatableText(String[] translatableTexts) {
        if (translatableTexts != null) {
            this.translatables.addAll(Arrays.asList(translatableTexts));
        }
    }

    public void setGuiCoord(int x, int y) {
        this.guiLeft = x;
        this.guiTop = y;
    }

    public boolean isMouseOver(int mouseX, int mouseY, int x, int y) {
        return this.guiLeft + x <= mouseX && mouseX <= this.guiLeft + x + width && this.guiTop + y <= mouseY && mouseY <= this.guiTop + y + height;
    }

    public void renderHoveredToolTip(GuiGraphics guiGraphics, int mouseX, int mouseY, BaseItemStackHandler inventory) {
        if (LibXClientConfig.slotInfo && this.slots.size() >= 1) {
            for (Integer key : this.slots.keySet()) {
                int[] x_y = this.slots.get(key);
                if (!this.isMouseOver(mouseX, mouseY, x_y[0], x_y[1]) || !inventory.getStackInSlot(key.intValue()).m_41619_()) continue;
                MutableComponent text = Component.m_237115_((String)this.translatables.get(key));
                guiGraphics.m_280557_(this.parent.getMinecraft().f_91062_, (Component)text, mouseX, mouseY);
            }
        }
    }
}

