/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.util.ProxyUtils;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.common.network.packet.IPacketClient;
import cofh.lib.common.network.packet.PacketBase;
import cofh.lib.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TileGuiPacket
extends PacketBase
implements IPacketClient {
    protected BlockPos pos;
    protected FriendlyByteBuf buffer;

    public TileGuiPacket() {
        super(2, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        Level world = ProxyUtils.getClientWorld();
        if (world == null) {
            this.handler.log().error("Client world is null! (Is this being called on the server?)");
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof IPacketHandlerTile) {
            IPacketHandlerTile handlerTile = (IPacketHandlerTile)tile;
            handlerTile.handleGuiPacket(this.buffer);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.buffer = buf;
        this.pos = this.buffer.m_130135_();
    }

    public static void sendToClient(IPacketHandlerTile tile, ServerPlayer player) {
        if (tile.world() == null || Utils.isClientWorld(tile.world())) {
            return;
        }
        TileGuiPacket packet = new TileGuiPacket();
        packet.pos = tile.pos();
        packet.buffer = tile.getGuiPacket(new FriendlyByteBuf(Unpooled.buffer()));
        packet.sendToPlayer(player);
    }
}

