/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.helpers.ItemHelper;
import cofh.lib.common.inventory.ItemStorageCoFH;
import cofh.lib.common.inventory.SlotFalseCopy;
import cofh.lib.util.helpers.BlockHelper;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public final class InventoryHelper {
    private InventoryHelper() {
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int startIndex, int endIndex) {
        if (stack.m_41619_()) {
            return true;
        }
        int openSlot = -1;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (ItemHelper.itemsEqualWithTags(stack, inventory[i]) && inventory[i].m_41741_() > inventory[i].m_41613_()) {
                int hold = inventory[i].m_41741_() - inventory[i].m_41613_();
                if (hold >= stack.m_41613_()) {
                    inventory[i].m_41769_(stack.m_41613_());
                    return true;
                }
                stack.m_41774_(hold);
                inventory[i].m_41769_(hold);
                continue;
            }
            if (!inventory[i].m_41619_() || openSlot != -1) continue;
            openSlot = i;
        }
        if (openSlot <= -1) {
            return false;
        }
        inventory[openSlot] = stack;
        return true;
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack, int startIndex) {
        return InventoryHelper.addItemStackToInventory(inventory, stack, startIndex, inventory.length - 1);
    }

    public static boolean addItemStackToInventory(ItemStack[] inventory, ItemStack stack) {
        return InventoryHelper.addItemStackToInventory(inventory, stack, 0);
    }

    public static ItemStack insertStackIntoInventory(IItemHandler handler, ItemStack stack, boolean simulate) {
        return InventoryHelper.insertStackIntoInventory(handler, stack, simulate, false);
    }

    public static ItemStack insertStackIntoInventory(IItemHandler handler, ItemStack stack, boolean simulate, boolean forceEmptySlot) {
        return forceEmptySlot ? ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate) : ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
    }

    public static boolean mergeItemStack(List<Slot> slots, ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack stackInSlot;
        Slot slot;
        int iterOrder;
        boolean successful = false;
        int i = reverseDirection ? endIndex - 1 : startIndex;
        int n = iterOrder = reverseDirection ? -1 : 1;
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = slots.get(i);
                if (slot instanceof SlotFalseCopy || !slot.m_5857_(stack)) {
                    i += iterOrder;
                    continue;
                }
                stackInSlot = slot.m_7993_();
                if (!stackInSlot.m_41619_() && ItemHelper.itemsEqualWithTags(stackInSlot, stack)) {
                    int maxSize;
                    int size = stackInSlot.m_41613_() + stack.m_41613_();
                    if (size <= (maxSize = Math.min(stack.m_41741_(), slot.m_6641_()))) {
                        stack.m_41764_(0);
                        stackInSlot.m_41764_(size);
                        slot.m_5852_(stackInSlot);
                        successful = true;
                    } else if (stackInSlot.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - stackInSlot.m_41613_());
                        stackInSlot.m_41764_(maxSize);
                        slot.m_5852_(stackInSlot);
                        successful = true;
                    }
                }
                i += iterOrder;
            }
        }
        if (!stack.m_41619_()) {
            int n2 = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = slots.get(i);
                if (slot instanceof SlotFalseCopy) {
                    i += iterOrder;
                    continue;
                }
                stackInSlot = slot.m_7993_();
                if (stackInSlot.m_41619_() && slot.m_5857_(stack)) {
                    int maxSize = Math.min(stack.m_41741_(), slot.m_6641_());
                    int splitSize = Math.min(maxSize, stack.m_41613_());
                    slot.m_5852_(stack.m_41620_(splitSize));
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    public static boolean extractFromAdjacent(BlockEntity tile, ItemStorageCoFH slot, int amount, Direction side) {
        Direction opposite;
        BlockEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        if (InventoryHelper.hasItemHandlerCap(adjTile, opposite = side.m_122424_())) {
            IItemHandler handler = InventoryHelper.getItemHandlerCap(adjTile, opposite);
            if (handler == EmptyHandler.INSTANCE) {
                return false;
            }
            int initialAmount = amount;
            for (int i = 0; i < handler.getSlots() && amount > 0; ++i) {
                ItemStack ret;
                ItemStack query = handler.extractItem(i, amount, true);
                if (query.m_41619_() || (ret = slot.insertItem(0, query, true)).m_41613_() == query.m_41613_()) continue;
                slot.insertItem(0, handler.extractItem(i, amount, false), false);
                amount -= query.m_41613_() - ret.m_41613_();
            }
            return amount != initialAmount;
        }
        return false;
    }

    public static boolean insertIntoAdjacent(BlockEntity tile, ItemStorageCoFH slot, int amount, Direction side) {
        if (slot.isEmpty()) {
            return false;
        }
        ItemStack initialStack = slot.getItemStack().m_41777_();
        initialStack.m_41764_(Math.min(amount, initialStack.m_41613_()));
        BlockEntity adjTile = BlockHelper.getAdjacentTileEntity(tile, side);
        Direction opposite = side.m_122424_();
        if (InventoryHelper.hasItemHandlerCap(adjTile, opposite)) {
            ItemStack inserted = InventoryHelper.insertStackIntoInventory(InventoryHelper.getItemHandlerCap(adjTile, opposite), initialStack, false);
            if (inserted.m_41613_() >= initialStack.m_41613_()) {
                return false;
            }
            slot.modify(inserted.m_41613_() - initialStack.m_41613_());
            return true;
        }
        return false;
    }

    public static ItemStack addToInventory(BlockEntity tile, Direction side, ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (InventoryHelper.hasItemHandlerCap(tile, side.m_122424_())) {
            stack = InventoryHelper.insertStackIntoInventory(InventoryHelper.getItemHandlerCap(tile, side.m_122424_()), stack, false);
        }
        return stack;
    }

    public static boolean hasItemHandlerCap(BlockEntity tile, Direction face) {
        return tile != null && tile.getCapability(ForgeCapabilities.ITEM_HANDLER, face).isPresent() || tile instanceof Container;
    }

    public static IItemHandler getItemHandlerCap(BlockEntity tile, Direction face) {
        if (tile.getCapability(ForgeCapabilities.ITEM_HANDLER, face).isPresent()) {
            return (IItemHandler)tile.getCapability(ForgeCapabilities.ITEM_HANDLER, face).orElse((Object)EmptyHandler.INSTANCE);
        }
        if (tile instanceof WorldlyContainer && face != null) {
            return new SidedInvWrapper((WorldlyContainer)tile, face);
        }
        if (tile instanceof Container) {
            return new InvWrapper((Container)tile);
        }
        return EmptyHandler.INSTANCE;
    }

    public static boolean isEmpty(ItemStack[] inventory) {
        for (ItemStack stack : inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }
}

