/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.raytracer;

import cofh.lib.util.raytracer.IndexedVoxelShape;
import cofh.lib.util.raytracer.VoxelShapeBlockHitResult;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MultiIndexedVoxelShape
extends VoxelShape {
    private final VoxelShape merged;
    private final ImmutableSet<IndexedVoxelShape> shapes;

    public MultiIndexedVoxelShape(ImmutableSet<IndexedVoxelShape> shapes) {
        this(MultiIndexedVoxelShape.mergeAll(shapes), shapes);
    }

    public MultiIndexedVoxelShape(VoxelShape merged, ImmutableSet<IndexedVoxelShape> shapes) {
        super(merged.f_83211_);
        this.merged = merged;
        this.shapes = shapes;
    }

    public DoubleList m_7700_(Direction.Axis axis) {
        return this.merged.m_7700_(axis);
    }

    @Nullable
    public VoxelShapeBlockHitResult clip(Vec3 start, Vec3 end, BlockPos pos) {
        VoxelShapeBlockHitResult closest = null;
        double dist = Double.MAX_VALUE;
        for (IndexedVoxelShape shape : this.shapes) {
            VoxelShapeBlockHitResult hit = shape.clip(start, end, pos);
            if (hit == null || !(dist >= hit.dist)) continue;
            closest = hit;
            dist = hit.dist;
        }
        return closest;
    }

    private static VoxelShape mergeAll(Set<? extends VoxelShape> shapes) {
        Set<? extends VoxelShape> genericsDie = shapes;
        return genericsDie.stream().reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }
}

