/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.config;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.api.event.HeartRegistry;
import terrails.colorfulhearts.api.heart.Hearts;
import terrails.colorfulhearts.api.heart.drawing.HeartDrawing;
import terrails.colorfulhearts.api.heart.drawing.OverlayHeart;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.render.RenderUtils;

public class ConfigUtils {
    public static void loadColoredHearts() {
        ResourceLocation id;
        Integer color;
        ArrayList<HeartDrawing> hearts = new ArrayList<HeartDrawing>();
        if (Configuration.HEALTH.vanillaHearts.get().booleanValue()) {
            hearts.add(new HeartDrawing(){
                private static final ResourceLocation ID = new ResourceLocation("vanilla");

                @Override
                public void draw(GuiGraphics guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.GUI_ICONS_LOCATION);
                    int texX = Gui.HeartType.NORMAL.m_168734_(half, highlight);
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, hardcore ? 45 : 0);
                }

                @Override
                public ResourceLocation getId() {
                    return ID;
                }
            });
        }
        Iterator colors = Configuration.HEALTH.colors.get().stream().map(s -> Integer.decode(s) & 0xFFFFFF).iterator();
        while (colors.hasNext()) {
            color = (Integer)colors.next();
            id = new ResourceLocation("colorfulhearts", "health_" + color);
            hearts.add(new HeartDrawing(){

                @Override
                public void draw(GuiGraphics guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.HEALTH_ICONS_LOCATION);
                    RenderSystem.enableBlend();
                    int texX = 0;
                    if (half) {
                        texX += 9;
                    }
                    int texY = hardcore ? 36 : 0;
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY, color, 255);
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY += 9, 255);
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY += 9, 255);
                    if (highlight) {
                        RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY -= 18, 127);
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.GUI_ICONS_LOCATION);
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }
            });
        }
        Hearts.COLORED_HEALTH_HEARTS = List.copyOf(hearts);
        hearts = new ArrayList();
        if (Configuration.ABSORPTION.vanillaHearts.get().booleanValue()) {
            hearts.add(new HeartDrawing(){
                private static final ResourceLocation ID = new ResourceLocation("absorbing");

                @Override
                public void draw(GuiGraphics guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.GUI_ICONS_LOCATION);
                    int texX = Gui.HeartType.ABSORBING.m_168734_(half, highlight);
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, hardcore ? 45 : 0);
                }

                @Override
                public ResourceLocation getId() {
                    return ID;
                }
            });
        }
        colors = Configuration.ABSORPTION.colors.get().stream().map(s -> Integer.decode(s) & 0xFFFFFF).iterator();
        while (colors.hasNext()) {
            color = (Integer)colors.next();
            id = new ResourceLocation("colorfulhearts", "absorbing_" + color);
            hearts.add(new HeartDrawing(){

                @Override
                public void draw(GuiGraphics guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.ABSORPTION_ICONS_LOCATION);
                    RenderSystem.enableBlend();
                    int texX = 0;
                    if (half) {
                        texX += 9;
                    }
                    int texY = hardcore ? 36 : 0;
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY, color, 255);
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY += 9, 255);
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY += 9, 255);
                    if (highlight) {
                        RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY -= 18, 127);
                    }
                    RenderSystem.disableBlend();
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.GUI_ICONS_LOCATION);
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }
            });
        }
        Hearts.COLORED_ABSORPTION_HEARTS = List.copyOf(hearts);
    }

    public static void loadStatusEffectHearts() {
        HeartRegistry registry = new HeartRegistry();
        registry.registerOverlayHeart(ConfigUtils.buildEffectHeart(Configuration.HEALTH.poisonedColors.get(), Configuration.ABSORPTION.poisonedColors.get(), Gui.HeartType.POISIONED));
        registry.registerOverlayHeart(ConfigUtils.buildEffectHeart(Configuration.HEALTH.witheredColors.get(), Configuration.ABSORPTION.witheredColors.get(), Gui.HeartType.WITHERED));
        registry.registerOverlayHeart(ConfigUtils.buildEffectHeart(Configuration.HEALTH.frozenColors.get(), Configuration.ABSORPTION.frozenColors.get(), Gui.HeartType.FROZEN));
        CColorfulHearts.PROXY.heartRegistryEvent(registry);
    }

    private static OverlayHeart buildEffectHeart(List<String> healthColors, List<String> absorptionColors, final Gui.HeartType type) {
        ResourceLocation id;
        Integer color;
        Predicate<Player> predicate;
        String effectName;
        ArrayList<HeartDrawing> drawings = new ArrayList<HeartDrawing>();
        final int textureX = switch (type) {
            case Gui.HeartType.POISIONED -> {
                effectName = "poison";
                predicate = player -> player.m_21023_(MobEffects.f_19614_);
                yield 18;
            }
            case Gui.HeartType.WITHERED -> {
                effectName = "wither";
                predicate = player -> player.m_21023_(MobEffects.f_19615_);
                yield 36;
            }
            case Gui.HeartType.FROZEN -> {
                effectName = "frozen";
                predicate = Entity::m_146890_;
                yield 54;
            }
            default -> throw new IllegalArgumentException("Tried to build a StatusEffectHeart for invalid type: " + String.valueOf(type));
        };
        Iterator colors = healthColors.stream().map(s -> Integer.decode(s) & 0xFFFFFF).iterator();
        while (colors.hasNext()) {
            color = (Integer)colors.next();
            id = new ResourceLocation("colorfulhearts", effectName + "_" + color);
            drawings.add(new HeartDrawing(){

                @Override
                public void draw(GuiGraphics guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.HEALTH_ICONS_LOCATION);
                    int texX = textureX;
                    if (half) {
                        texX += 9;
                    }
                    int texY = hardcore ? 36 : 0;
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY, color, 255);
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY += 9, 255);
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY += 9, 255);
                    if (highlight) {
                        RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY -= 18, 127);
                    }
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.GUI_ICONS_LOCATION);
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }
            });
        }
        if (drawings.size() == 1) {
            final ResourceLocation id2 = new ResourceLocation("colorfulhearts", effectName + "_vanilla");
            drawings.add(0, new HeartDrawing(){

                @Override
                public void draw(GuiGraphics guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.GUI_ICONS_LOCATION);
                    int texX = type.m_168734_(half, highlight);
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, hardcore ? 45 : 0);
                }

                @Override
                public ResourceLocation getId() {
                    return id2;
                }
            });
        }
        colors = absorptionColors.stream().map(s -> Integer.decode(s) & 0xFFFFFF).iterator();
        while (colors.hasNext()) {
            color = (Integer)colors.next();
            id = new ResourceLocation("colorfulhearts", effectName + "_absorbing_" + color);
            drawings.add(new HeartDrawing(){

                @Override
                public void draw(GuiGraphics guiGraphics, int x, int y, boolean half, boolean hardcore, boolean highlight) {
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.ABSORPTION_ICONS_LOCATION);
                    int texX = textureX;
                    if (half) {
                        texX += 9;
                    }
                    int texY = hardcore ? 36 : 0;
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY, color, 255);
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY += 9, 255);
                    RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY += 9, 255);
                    if (highlight) {
                        RenderUtils.drawTexture(guiGraphics.m_280168_(), x, y, texX, texY -= 18, 127);
                    }
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)CColorfulHearts.GUI_ICONS_LOCATION);
                }

                @Override
                public ResourceLocation getId() {
                    return id;
                }
            });
        }
        return OverlayHeart.build(new ResourceLocation(effectName), predicate).addHealth((HeartDrawing)drawings.get(0), (HeartDrawing)drawings.get(1)).addAbsorption((HeartDrawing)drawings.get(2), (HeartDrawing)drawings.get(3)).finish();
    }
}

